/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import io.micrometer.core.instrument.LongTaskTimer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.slf4j.LoggerFactory;

public class CompactionWatcher
implements Runnable {
    private final Map<List<Long>, ObservedCompactionInfo> observedCompactions = new HashMap<List<Long>, ObservedCompactionInfo>();
    private final AccumuloConfiguration config;
    private static boolean watching = false;
    private static LongTaskTimer timer = null;

    public static void setTimer(LongTaskTimer ltt) {
        timer = ltt;
    }

    public CompactionWatcher(AccumuloConfiguration config) {
        this.config = config;
    }

    @Override
    public void run() {
        List<CompactionInfo> runningCompactions = FileCompactor.getRunningCompactions();
        HashSet<List<Long>> newKeys = new HashSet<List<Long>>();
        long time = System.currentTimeMillis();
        for (CompactionInfo compactionInfo : runningCompactions) {
            List<Long> compactionKey = Arrays.asList(compactionInfo.getID(), compactionInfo.getEntriesRead(), compactionInfo.getEntriesWritten());
            newKeys.add(compactionKey);
            if (this.observedCompactions.containsKey(compactionKey)) continue;
            this.observedCompactions.put(compactionKey, new ObservedCompactionInfo(compactionInfo, time));
        }
        HashMap<List<Long>, ObservedCompactionInfo> copy = new HashMap<List<Long>, ObservedCompactionInfo>(this.observedCompactions);
        copy.keySet().removeAll(newKeys);
        for (ObservedCompactionInfo oci : copy.values()) {
            if (oci.stuckSample != null) {
                oci.stuckSample.stop();
                oci.stuckSample = null;
            }
            if (!oci.loggedWarning) continue;
            LoggerFactory.getLogger(CompactionWatcher.class).info("Compaction of {} is no longer stuck", (Object)oci.compactionInfo.getExtent());
        }
        this.observedCompactions.keySet().retainAll(newKeys);
        long l = this.config.getTimeInMillis(Property.TSERV_COMPACTION_WARN_TIME);
        for (ObservedCompactionInfo oci : this.observedCompactions.values()) {
            Thread compactionThread;
            if (time - oci.firstSeen <= l) continue;
            LongTaskTimer.Sample sample = oci.stuckSample = timer == null ? null : timer.start();
            if (oci.loggedWarning || (compactionThread = oci.compactionInfo.getThread()) == null) continue;
            StackTraceElement[] trace = compactionThread.getStackTrace();
            Exception e = new Exception("Possible stack trace of compaction stuck on " + String.valueOf(oci.compactionInfo.getExtent()));
            e.setStackTrace(trace);
            LoggerFactory.getLogger(CompactionWatcher.class).warn("Compaction of " + String.valueOf(oci.compactionInfo.getExtent()) + " to " + oci.compactionInfo.getOutputFile() + " has not made progress for at least " + (time - oci.firstSeen) + "ms", (Throwable)e);
            oci.loggedWarning = true;
        }
    }

    public static synchronized void startWatching(ServerContext context) {
        if (!watching) {
            ThreadPools.watchCriticalScheduledTask(context.getScheduledExecutor().scheduleWithFixedDelay(new CompactionWatcher(context.getConfiguration()), 10000L, 10000L, TimeUnit.MILLISECONDS));
            watching = true;
        }
    }

    private static class ObservedCompactionInfo {
        final CompactionInfo compactionInfo;
        final long firstSeen;
        LongTaskTimer.Sample stuckSample;
        boolean loggedWarning;

        ObservedCompactionInfo(CompactionInfo ci, long time) {
            this.compactionInfo = ci;
            this.firstSeen = time;
        }
    }
}

