/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.util.EnumSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.iterators.IteratorUtil;

public interface NamespaceOperations {
    public String systemNamespace();

    public String defaultNamespace();

    public SortedSet<String> list() throws AccumuloException, AccumuloSecurityException;

    public boolean exists(String var1) throws AccumuloException, AccumuloSecurityException;

    public void create(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException;

    public void delete(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException;

    public void rename(String var1, String var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceExistsException;

    public void setProperty(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public Map<String, String> modifyProperties(String var1, Consumer<Map<String, String>> var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public void removeProperty(String var1, String var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    default public Iterable<Map.Entry<String, String>> getProperties(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        return this.getConfiguration(namespace).entrySet();
    }

    public Map<String, String> getConfiguration(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public Map<String, String> getNamespaceProperties(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public Map<String, String> namespaceIdMap() throws AccumuloException, AccumuloSecurityException;

    public void attachIterator(String var1, IteratorSetting var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public void attachIterator(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public void removeIterator(String var1, String var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public IteratorSetting getIteratorSetting(String var1, String var2, IteratorUtil.IteratorScope var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public Map<String, EnumSet<IteratorUtil.IteratorScope>> listIterators(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public void checkIteratorConflicts(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public int addConstraint(String var1, String var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public void removeConstraint(String var1, int var2) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public Map<String, Integer> listConstraints(String var1) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;

    public boolean testClassLoad(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException;
}

