/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonService;

public class ZooCacheFactory {
    private static final Map<String, ZooCache> instances = new HashMap<String, ZooCache>();
    private static boolean enabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enable() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disable() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            try {
                instances.values().forEach(ZooCache::close);
            }
            finally {
                instances.clear();
                enabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooCache getZooCache(String zooKeepers, int sessionTimeout) {
        String key = zooKeepers + ":" + sessionTimeout;
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            if (!ZooCacheFactory.isEnabled()) {
                throw new IllegalStateException("The Accumulo singleton for zookeeper caching is disabled. This is likely caused by all AccumuloClients being closed");
            }
            return instances.computeIfAbsent(key, k -> this.getNewZooCache(zooKeepers, sessionTimeout));
        }
    }

    public ZooCache getNewZooCache(String zooKeepers, int sessionTimeout) {
        return new ZooCache(new ZooReader(zooKeepers, sessionTimeout), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            instances.clear();
        }
    }

    static {
        SingletonManager.register(new SingletonService(){

            @Override
            public synchronized boolean isEnabled() {
                return ZooCacheFactory.isEnabled();
            }

            @Override
            public synchronized void enable() {
                ZooCacheFactory.enable();
            }

            @Override
            public synchronized void disable() {
                ZooCacheFactory.disable();
            }
        });
    }
}

