/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.crl.PlainCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.CRLParameters;
import java.io.File;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509CRL;
import java.util.Collections;
import java.util.Timer;

public class OpensslCRLStoreSpi
extends PlainCRLStoreSpi {
    public static final String CRL_WILDCARD = "????????.r*";
    private boolean openssl1Mode;

    public OpensslCRLStoreSpi(String path, long crlUpdateInterval, Timer t, ObserversHandler observers, boolean openssl1Mode) throws InvalidAlgorithmParameterException {
        super(new CRLParameters(Collections.singletonList(path + File.separator + CRL_WILDCARD), crlUpdateInterval, 0, null), t, observers);
        this.openssl1Mode = openssl1Mode;
        super.start();
    }

    @Override
    protected X509CRL reloadCRL(URL location) {
        X509CRL crl;
        String fileHash = OpensslTruststoreHelper.getFileHash(location.getPath(), "^([0-9a-fA-F]{8})\\.r[\\d]+$");
        if (fileHash == null) {
            return null;
        }
        try {
            crl = this.loadCRL(location);
        }
        catch (Exception e) {
            this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.ERROR, e);
            return null;
        }
        String crlHash = OpensslTruststoreHelper.getOpenSSLCAHash(crl.getIssuerX500Principal(), this.openssl1Mode);
        if (!fileHash.equalsIgnoreCase(crlHash)) {
            return null;
        }
        this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.NOTIFICATION, null);
        this.addCRL(crl, location);
        return crl;
    }
}

