/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;

public class ProxySAMLExtension
extends ASN1Object {
    public static final String SAML_OID = "1.3.6.1.4.1.3536.1.1.1.12";
    public static final String LEGACY_SAML_OID = "1.3.6.1.4.1.3536.1.1.1.10";
    private DEROctetString saml = null;

    public ProxySAMLExtension(byte[] bytes) throws IOException {
        this.saml = (DEROctetString)ASN1Primitive.fromByteArray((byte[])bytes);
    }

    public ProxySAMLExtension(String samlString) {
        try {
            this.saml = new DEROctetString(samlString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is unsupported - JDK problem", e);
        }
    }

    public static ProxySAMLExtension getInstance(X509Certificate cert) throws IOException {
        byte[] bytes = CertificateHelpers.getExtensionBytes(cert, SAML_OID);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ProxySAMLExtension(bytes);
    }

    public String getSAML() {
        try {
            return new String(this.saml.getOctets(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is unsupported - JDK problem", e);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        return this.saml.toASN1Primitive();
    }
}

