/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms;

import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.utils.RDBMSDataSourceUtils;

public class RDBMSDataSource {
    private DataSource dataSource;
    private Reference dataSourceFactoryReference;
    private PoolConfiguration poolProperties;

    public RDBMSDataSource(RDBMSConfiguration config) throws DataSourceException {
        this.poolProperties = RDBMSDataSourceUtils.createPoolConfiguration(config);
        this.populateStandardProps();
    }

    private void populateStandardProps() {
        String jdbcInterceptors = this.poolProperties.getJdbcInterceptors();
        if (jdbcInterceptors == null) {
            jdbcInterceptors = "";
        }
        jdbcInterceptors = "ConnectionState;StatementFinalizer;org.wso2.carbon.ndatasource.rdbms.ConnectionRollbackOnReturnInterceptor;" + jdbcInterceptors;
        this.poolProperties.setJdbcInterceptors(jdbcInterceptors);
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new DataSource(this.poolProperties);
        }
        return this.dataSource;
    }

    public Reference getDataSourceFactoryReference() throws DataSourceException {
        if (this.dataSourceFactoryReference == null) {
            this.dataSourceFactoryReference = new Reference("org.apache.tomcat.jdbc.pool.DataSource", "org.apache.tomcat.jdbc.pool.DataSourceFactory", null);
            Map<String, String> poolConfigMap = RDBMSDataSourceUtils.extractPrimitiveFieldNameValuePairs(this.poolProperties);
            for (Map.Entry<String, String> pairs : poolConfigMap.entrySet()) {
                this.dataSourceFactoryReference.add(new StringRefAddr(pairs.getKey(), pairs.getValue()));
            }
        }
        return this.dataSourceFactoryReference;
    }
}

