/*
 * Decompiled with CFR 0.152.
 */
package org.globus.myproxy;

import org.globus.myproxy.MyProxyConstants;

public abstract class Params
implements MyProxyConstants {
    private int command;
    protected String username;
    protected String passphrase;
    protected int lifetime = 43200;

    public Params(int command) {
        this.setCommand(command);
    }

    public Params(int command, String username, String passphrase) {
        this.setCommand(command);
        this.setUserName(username);
        this.setPassphrase(passphrase);
    }

    protected void setCommand(int command) {
        this.command = command;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassphrase(String passphrase) {
        this.checkPassphrase(passphrase);
        this.passphrase = passphrase;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setLifetime(int seconds) {
        this.lifetime = seconds;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    protected void checkPassphrase(String passphrase) {
        if (passphrase == null) {
            throw new IllegalArgumentException("Password is not specified");
        }
        if (passphrase.length() < 6) {
            throw new IllegalArgumentException("Password must be at least 6 characters long");
        }
    }

    public String makeRequest() {
        return this.makeRequest(true);
    }

    protected String makeRequest(boolean includePassword) {
        StringBuffer buf = new StringBuffer();
        buf.append("VERSION=MYPROXYv2").append("\n");
        buf.append("COMMAND=").append(String.valueOf(this.command)).append("\n");
        buf.append("USERNAME=").append(this.username).append("\n");
        String pwd = this.getPassphrase();
        buf.append("PASSPHRASE=");
        if (includePassword) {
            if (pwd != null) {
                buf.append(pwd);
            }
        } else {
            for (int i = 0; pwd != null && i < pwd.length(); ++i) {
                buf.append('*');
            }
        }
        buf.append("\n");
        buf.append("LIFETIME=").append(String.valueOf(this.lifetime)).append("\n");
        return buf.toString();
    }

    protected void add(StringBuffer buf, String prefix, String value) {
        if (value == null) {
            return;
        }
        buf.append(prefix).append(value).append("\n");
    }

    public String toString() {
        return this.makeRequest(false);
    }
}

