/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.keystore;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.IKeyStoreLoader;
import org.wso2.securevault.SecureVaultException;

public class PKCS8KeyStoreLoader
implements IKeyStoreLoader {
    private static Log log = LogFactory.getLog(PKCS8KeyStoreLoader.class);
    private String pkPath;
    private String certPath;
    private String keyPassword;
    private String entryAlias;
    private static final String HEADER = "-----BEGIN PRIVATE KEY-----\n";
    private static final String FOOTER = "-----END PRIVATE KEY-----";

    public PKCS8KeyStoreLoader(String pkcs8PrivateKeyPath, String certFilePath, String keyPass, String entryAlias) {
        this.pkPath = pkcs8PrivateKeyPath;
        this.certPath = certFilePath;
        this.keyPassword = keyPass;
        this.entryAlias = entryAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() {
        File file = new File(this.pkPath);
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no private key in the given path : " + this.pkPath));
            }
            return null;
        }
        File certFile = new File(this.certPath);
        if (!certFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no certificate in the given path : " + this.certPath));
            }
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading a private key(unencrypted) from given path : " + this.pkPath));
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try {
                int length;
                while ((length = bufferedInputStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
            }
            catch (IOException e) {
                this.handleException("IOError reading from file :  " + this.pkPath, e);
            }
            finally {
                try {
                    bufferedInputStream.close();
                    fileInputStream.close();
                    outStream.close();
                }
                catch (IOException ignored) {}
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a private key in PKCS8Encoded using given (unencrypted) RSA private key ");
            }
            PrivateKey key = this.createPrivateKey(outStream.toByteArray());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Generating a X509 certificate form given certificate file");
            }
            FileInputStream certInputStream = new FileInputStream(certFile);
            BufferedInputStream certBufferedInputStream = new BufferedInputStream(certInputStream);
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Certificate cert = certFactory.generateCertificate(certBufferedInputStream);
            certBufferedInputStream.close();
            certInputStream.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a KeyStore instance of type JKS from a PKCS8 private key and X509 certificate");
            }
            KeyStore newKeyStore = KeyStore.getInstance("JKS");
            newKeyStore.load(null, null);
            newKeyStore.setCertificateEntry("server Cert", cert);
            Certificate[] certChain = new Certificate[]{cert};
            newKeyStore.setKeyEntry(this.entryAlias, key, this.keyPassword.toCharArray(), certChain);
            return newKeyStore;
        }
        catch (FileNotFoundException e) {
            this.handleException("IOError", e);
        }
        catch (IOException e) {
            this.handleException("IOError", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Error creating KeyStore", e);
        }
        catch (KeyStoreException e) {
            this.handleException("Error creating KeyStore", e);
        }
        catch (CertificateException e) {
            this.handleException("Error creating KeyStore", e);
        }
        return null;
    }

    private PrivateKey createPrivateKey(byte[] keyBytes) {
        int dataStart = HEADER.length();
        int dataEnd = keyBytes.length - FOOTER.length() - 1;
        int dataLength = dataEnd - dataStart;
        byte[] keyContent = new byte[dataLength];
        System.arraycopy(keyBytes, dataStart, keyContent, 0, dataLength);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64Utils.decode((String)new String(keyContent)));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Error getting a KeyFactory instance", e);
        }
        catch (InvalidKeySpecException e) {
            this.handleException("Error generating a private key", e);
        }
        return null;
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SecureVaultException(msg, e);
    }
}

