/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyEventSubscriptionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String subscriptionName;
    private String snsTopicArn;
    private String sourceType;
    private ListWithAutoConstructFlag<String> eventCategories;
    private Boolean enabled;

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public ModifyEventSubscriptionRequest withSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public String getSnsTopicArn() {
        return this.snsTopicArn;
    }

    public void setSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
    }

    public ModifyEventSubscriptionRequest withSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public ModifyEventSubscriptionRequest withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new ListWithAutoConstructFlag();
            this.eventCategories.setAutoConstruct(true);
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
        eventCategoriesCopy.addAll(eventCategories);
        this.eventCategories = eventCategoriesCopy;
    }

    public ModifyEventSubscriptionRequest withEventCategories(String ... eventCategories) {
        if (this.getEventCategories() == null) {
            this.setEventCategories(new ArrayList<String>(eventCategories.length));
        }
        for (String value : eventCategories) {
            this.getEventCategories().add(value);
        }
        return this;
    }

    public ModifyEventSubscriptionRequest withEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
        } else {
            ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
            eventCategoriesCopy.addAll(eventCategories);
            this.eventCategories = eventCategoriesCopy;
        }
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ModifyEventSubscriptionRequest withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubscriptionName() != null) {
            sb.append("SubscriptionName: " + this.getSubscriptionName() + ",");
        }
        if (this.getSnsTopicArn() != null) {
            sb.append("SnsTopicArn: " + this.getSnsTopicArn() + ",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: " + this.getSourceType() + ",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: " + this.getEventCategories() + ",");
        }
        if (this.isEnabled() != null) {
            sb.append("Enabled: " + this.isEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubscriptionName() == null ? 0 : this.getSubscriptionName().hashCode());
        hashCode = 31 * hashCode + (this.getSnsTopicArn() == null ? 0 : this.getSnsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : this.getEventCategories().hashCode());
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionRequest)) {
            return false;
        }
        ModifyEventSubscriptionRequest other = (ModifyEventSubscriptionRequest)obj;
        if (other.getSubscriptionName() == null ^ this.getSubscriptionName() == null) {
            return false;
        }
        if (other.getSubscriptionName() != null && !other.getSubscriptionName().equals(this.getSubscriptionName())) {
            return false;
        }
        if (other.getSnsTopicArn() == null ^ this.getSnsTopicArn() == null) {
            return false;
        }
        if (other.getSnsTopicArn() != null && !other.getSnsTopicArn().equals(this.getSnsTopicArn())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !other.getEventCategories().equals(this.getEventCategories())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        return other.isEnabled() == null || other.isEnabled().equals(this.isEnabled());
    }
}

