/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class VirtualWebappLoader
extends WebappLoader {
    private static final Log log = LogFactory.getLog(VirtualWebappLoader.class);
    private String virtualClasspath;

    public VirtualWebappLoader() {
    }

    public VirtualWebappLoader(ClassLoader parent) {
        super(parent);
    }

    public void setVirtualClasspath(String path) {
        this.virtualClasspath = path;
    }

    public boolean getSearchVirtualFirst() {
        return this.getSearchExternalFirst();
    }

    public void setSearchVirtualFirst(boolean searchVirtualFirst) {
        this.setSearchExternalFirst(searchVirtualFirst);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringTokenizer tkn = new StringTokenizer(this.virtualClasspath, ";");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("virtualWebappLoader.token", token));
            }
            if (token.endsWith("*.jar")) {
                File directory = new File(token = token.substring(0, token.length() - "*.jar".length()));
                if (!directory.isDirectory()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("virtualWebappLoader.token.notDirectory", directory.getAbsolutePath()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("virtualWebappLoader.token.glob.dir", directory.getAbsolutePath()));
                }
                Object[] filenames = directory.list();
                Arrays.sort(filenames);
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = ((String)filenames[j]).toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, (String)filenames[j]);
                    if (!file.isFile()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)sm.getString("virtualWebappLoader.token.notFile", file.getAbsolutePath()));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("virtualWebappLoader.token.file", file.getAbsolutePath()));
                    }
                    set.add(file.toURI().toString());
                }
                continue;
            }
            File file = new File(token);
            if (!file.exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("virtualWebappLoader.token.notExists", file.getAbsolutePath()));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("virtualWebappLoader.token.file", file.getAbsolutePath()));
            }
            set.add(file.toURI().toString());
        }
        for (String repository : set) {
            this.addRepository(repository);
        }
        super.startInternal();
    }
}

