/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.GlobusGKEndPointPK;
import org.apache.airavata.registry.core.app.catalog.model.GlobusGKEndpoint;
import org.apache.airavata.registry.core.app.catalog.model.GlobusJobSubmission;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.GlobusJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobusGKEndpointResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GlobusGKEndpointResource.class);
    private String submissionID;
    private String endpoint;
    private GlobusJobSubmissionResource globusJobSubmissionResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GlobusGKEndpoint", new Object[0][]);
            generator.setParameter("endpoint", ids.get("endpoint"));
            generator.setParameter("submissionID", ids.get("submissionID"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GlobusGKEndpoint", new Object[0][]);
            generator.setParameter("submissionID", ids.get("submissionID"));
            generator.setParameter("endpoint", ids.get("endpoint"));
            Query q = generator.selectQuery(em);
            GlobusGKEndpoint gkEndpoint = (GlobusGKEndpoint)q.getSingleResult();
            GlobusGKEndpointResource gkEndpointResource = (GlobusGKEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GLOBUS_GK_ENDPOINT, gkEndpoint);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            GlobusGKEndpointResource globusGKEndpointResource = gkEndpointResource;
            return globusGKEndpointResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> resources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GlobusGKEndpoint", new Object[0][]);
            if (fieldName.equals("endpoint")) {
                generator.setParameter("endpoint", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusGKEndpoint gkEndpoint = (GlobusGKEndpoint)result;
                        GlobusGKEndpointResource gkEndpointResource = (GlobusGKEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GLOBUS_GK_ENDPOINT, gkEndpoint);
                        resources.add(gkEndpointResource);
                    }
                }
            } else if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusGKEndpoint globusGKEndpoint = (GlobusGKEndpoint)result;
                        GlobusGKEndpointResource gkEndpointResource = (GlobusGKEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GLOBUS_GK_ENDPOINT, globusGKEndpoint);
                        resources.add(gkEndpointResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Globus Endpoint Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Globus Endpoint Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> list = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GlobusGKEndpoint", new Object[0][]);
            if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusGKEndpoint globusGKEndpoint = (GlobusGKEndpoint)result;
                        list.add(globusGKEndpoint.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("endpoint")) {
                generator.setParameter("endpoint", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusGKEndpoint globusGKEndpoint = (GlobusGKEndpoint)result;
                        list.add(globusGKEndpoint.getSubmissionID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Globus EP resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Globus EP Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return list;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GlobusGKEndpoint existingGlobusEP = (GlobusGKEndpoint)em.find(GlobusGKEndpoint.class, (Object)new GlobusGKEndPointPK(this.submissionID, this.endpoint));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            GlobusJobSubmission globusJobSubmission = (GlobusJobSubmission)em.find(GlobusJobSubmission.class, (Object)this.submissionID);
            if (existingGlobusEP != null) {
                existingGlobusEP.setSubmissionID(this.submissionID);
                existingGlobusEP.setEndpoint(this.endpoint);
                existingGlobusEP.setGlobusSubmission(globusJobSubmission);
                em.merge((Object)existingGlobusEP);
            } else {
                GlobusGKEndpoint globusGKEndpoint = new GlobusGKEndpoint();
                globusGKEndpoint.setSubmissionID(this.submissionID);
                globusGKEndpoint.setEndpoint(this.endpoint);
                globusGKEndpoint.setGlobusSubmission(globusJobSubmission);
                em.persist((Object)globusGKEndpoint);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GlobusGKEndpoint gkEndpoint = (GlobusGKEndpoint)em.find(GlobusGKEndpoint.class, (Object)new GlobusGKEndPointPK((String)ids.get("submissionID"), (String)ids.get("endpoint")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = gkEndpoint != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(String submissionID) {
        this.submissionID = submissionID;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public GlobusJobSubmissionResource getGlobusJobSubmissionResource() {
        return this.globusJobSubmissionResource;
    }

    public void setGlobusJobSubmissionResource(GlobusJobSubmissionResource globusJobSubmissionResource) {
        this.globusJobSubmissionResource = globusJobSubmissionResource;
    }
}

