/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.LocalSubmission;
import org.apache.airavata.registry.core.app.catalog.model.ResourceJobManager;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSubmissionResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(LocalSubmissionResource.class);
    private String resourceJobManagerId;
    private ResourceJobManagerResource resourceJobManagerResource;
    private String jobSubmissionInterfaceId;
    private String securityProtocol;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("LocalSubmission", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("LocalSubmission", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", identifier);
            Query q = generator.selectQuery(em);
            LocalSubmission localSubmission = (LocalSubmission)q.getSingleResult();
            LocalSubmissionResource localSubmissionResource = (LocalSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.LOCAL_SUBMISSION, localSubmission);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            LocalSubmissionResource localSubmissionResource2 = localSubmissionResource;
            return localSubmissionResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> localSubmissionResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("LocalSubmission", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("jobSubmissionInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    LocalSubmission localSubmission = (LocalSubmission)result;
                    LocalSubmissionResource localSubmissionResource = (LocalSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.LOCAL_SUBMISSION, localSubmission);
                    localSubmissionResources.add(localSubmissionResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Local Submission Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Local Submission Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return localSubmissionResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> localSubmissionResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("LocalSubmission", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("jobSubmissionInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    LocalSubmission localSubmission = (LocalSubmission)result;
                    LocalSubmissionResource localSubmissionResource = (LocalSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.LOCAL_SUBMISSION, localSubmission);
                    localSubmissionResourceIDs.add(localSubmissionResource.getJobSubmissionInterfaceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Local Submission Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Local Submission Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return localSubmissionResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            LocalSubmission localSubmission;
            em = AppCatalogJPAUtils.getEntityManager();
            LocalSubmission existingLocalSubmission = (LocalSubmission)em.find(LocalSubmission.class, (Object)this.jobSubmissionInterfaceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingLocalSubmission == null) {
                localSubmission = new LocalSubmission();
                localSubmission.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                localSubmission = existingLocalSubmission;
                localSubmission.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            localSubmission.setResourceJobManagerId(this.getResourceJobManagerId());
            ResourceJobManager resourceJobManager = (ResourceJobManager)em.find(ResourceJobManager.class, (Object)this.getResourceJobManagerId());
            localSubmission.setResourceJobManager(resourceJobManager);
            localSubmission.setJobSubmissionInterfaceId(this.getJobSubmissionInterfaceId());
            localSubmission.setSecurityProtocol(this.getSecurityProtocol());
            if (existingLocalSubmission == null) {
                em.persist((Object)localSubmission);
            } else {
                em.merge((Object)localSubmission);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            LocalSubmission localSubmission = (LocalSubmission)em.find(LocalSubmission.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = localSubmission != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceJobManagerId() {
        return this.resourceJobManagerId;
    }

    public ResourceJobManagerResource getResourceJobManagerResource() {
        return this.resourceJobManagerResource;
    }

    public String getJobSubmissionInterfaceId() {
        return this.jobSubmissionInterfaceId;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setResourceJobManagerId(String resourceJobManagerId) {
        this.resourceJobManagerId = resourceJobManagerId;
    }

    public void setResourceJobManagerResource(ResourceJobManagerResource resourceJobManagerResource) {
        this.resourceJobManagerResource = resourceJobManagerResource;
    }

    public void setJobSubmissionInterfaceId(String jobSubmissionInterfaceId) {
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }
}

