/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Job;
import org.apache.airavata.registry.core.experiment.catalog.model.Task;
import org.apache.airavata.registry.core.experiment.catalog.model.TaskError;
import org.apache.airavata.registry.core.experiment.catalog.model.TaskStatus;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);
    private String taskId;
    private String taskType;
    private String parentProcessId;
    private Timestamp creationTime;
    private Timestamp lastUpdateTime;
    private String taskDetail;
    private byte[] subTaskModel;

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getParentProcessId() {
        return this.parentProcessId;
    }

    public void setParentProcessId(String parentProcessId) {
        this.parentProcessId = parentProcessId;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(String taskDetail) {
        this.taskDetail = taskDetail;
    }

    public byte[] getSubTaskModel() {
        return this.subTaskModel;
    }

    public void setSubTaskModel(byte[] subTaskModel) {
        this.subTaskModel = subTaskModel;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        switch (type) {
            case TASK_STATUS: {
                TaskStatusResource taskStatusResource = new TaskStatusResource();
                taskStatusResource.setTaskId(this.taskId);
                return taskStatusResource;
            }
            case TASK_ERROR: {
                TaskErrorResource taskErrorResource = new TaskErrorResource();
                taskErrorResource.setTaskId(this.taskId);
                return taskErrorResource;
            }
            case JOB: {
                JobResource jobResource = new JobResource();
                jobResource.setTaskId(this.taskId);
                return jobResource;
            }
        }
        logger.error("Unsupported resource type for task data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_STATUS: {
                    QueryGenerator generator = new QueryGenerator("TaskStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case TASK_ERROR: {
                    QueryGenerator generator = new QueryGenerator("TaskError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for job details resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_STATUS: {
                    QueryGenerator generator = new QueryGenerator("TaskStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.selectQuery(em);
                    TaskStatus status = (TaskStatus)q.getSingleResult();
                    TaskStatusResource statusResource = (TaskStatusResource)Utils.getResource(ResourceType.TASK_STATUS, status);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    TaskStatusResource taskStatusResource = statusResource;
                    return taskStatusResource;
                }
                case TASK_ERROR: {
                    QueryGenerator generator = new QueryGenerator("TaskError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.selectQuery(em);
                    TaskError error = (TaskError)q.getSingleResult();
                    TaskErrorResource errorResource = (TaskErrorResource)Utils.getResource(ResourceType.TASK_ERROR, error);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    TaskErrorResource taskErrorResource = errorResource;
                    return taskErrorResource;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    Job job = (Job)q.getSingleResult();
                    JobResource jobResource = (JobResource)Utils.getResource(ResourceType.JOB, job);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    JobResource jobResource2 = jobResource;
                    return jobResource2;
                }
            }
            try {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported resource type for Task resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for Task resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_ERROR: {
                    QueryGenerator generator = new QueryGenerator("TaskError", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        TaskError taskError = (TaskError)result;
                        TaskErrorResource taskErrorResource = (TaskErrorResource)Utils.getResource(ResourceType.TASK_ERROR, taskError);
                        resourceList.add(taskErrorResource);
                    }
                    break;
                }
                case TASK_STATUS: {
                    QueryGenerator generator = new QueryGenerator("TaskStatus", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        TaskStatus taskStatus = (TaskStatus)result;
                        TaskStatusResource taskStatusResource = (TaskStatusResource)Utils.getResource(ResourceType.TASK_STATUS, taskStatus);
                        resourceList.add(taskStatusResource);
                    }
                    break;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Job job = (Job)result;
                        JobResource jobResource = (JobResource)Utils.getResource(ResourceType.JOB, job);
                        resourceList.add(jobResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for task resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Task existingTask = (Task)em.find(Task.class, (Object)this.taskId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Task task = existingTask == null ? new Task() : existingTask;
            task.setTaskId(this.taskId);
            task.setTaskType(this.taskType);
            task.setParentProcessId(this.parentProcessId);
            task.setCreationTime(this.creationTime);
            task.setLastUpdateTime(this.lastUpdateTime);
            task.setTaskDetail(this.taskDetail);
            task.setSetSubTaskModel(this.subTaskModel);
            if (existingTask == null) {
                em.persist((Object)task);
            } else {
                em.merge((Object)task);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<TaskStatusResource> getTaskStatuses() throws RegistryException {
        ArrayList<TaskStatusResource> taskStatusResources = new ArrayList<TaskStatusResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.TASK_STATUS);
        for (ExperimentCatResource resource : resources) {
            TaskStatusResource statusResource = (TaskStatusResource)resource;
            taskStatusResources.add(statusResource);
        }
        return taskStatusResources;
    }

    public TaskStatusResource getTaskStatus() throws RegistryException {
        List<TaskStatusResource> taskStatusResources = this.getTaskStatuses();
        if (taskStatusResources.size() == 0) {
            return null;
        }
        TaskStatusResource max = taskStatusResources.get(0);
        for (int i = 1; i < taskStatusResources.size(); ++i) {
            if (!(taskStatusResources.get(i).getTimeOfStateChange().after(max.getTimeOfStateChange()) || taskStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) && taskStatusResources.get(i).getState().equals(TaskState.COMPLETED.toString()) || taskStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) && taskStatusResources.get(i).getState().equals(TaskState.FAILED.toString())) && (!taskStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) || !taskStatusResources.get(i).getState().equals(TaskState.CANCELED.toString()))) continue;
            max = taskStatusResources.get(i);
        }
        return max;
    }

    public List<TaskErrorResource> getTaskErrors() throws RegistryException {
        ArrayList<TaskErrorResource> taskErrorResources = new ArrayList<TaskErrorResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.TASK_ERROR);
        for (ExperimentCatResource resource : resources) {
            TaskErrorResource errorResource = (TaskErrorResource)resource;
            taskErrorResources.add(errorResource);
        }
        return taskErrorResources;
    }

    public TaskErrorResource getTaskError() throws RegistryException {
        List<TaskErrorResource> taskErrorResources = this.getTaskErrors();
        if (taskErrorResources.size() == 0) {
            return null;
        }
        TaskErrorResource max = taskErrorResources.get(0);
        for (int i = 1; i < taskErrorResources.size(); ++i) {
            if (!taskErrorResources.get(i).getCreationTime().after(max.getCreationTime())) continue;
            max = taskErrorResources.get(i);
        }
        return max;
    }

    public JobResource getJob(String jobId) throws RegistryException {
        return (JobResource)this.get(ResourceType.JOB, jobId);
    }

    public List<JobResource> getJobList() throws RegistryException {
        ArrayList<JobResource> jobResources = new ArrayList<JobResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.JOB);
        for (ExperimentCatResource resource : resources) {
            JobResource jobResource = (JobResource)resource;
            jobResources.add(jobResource);
        }
        return jobResources;
    }
}

