/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.replica.catalog.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataProductType;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.registry.core.replica.catalog.model.DataProduct;
import org.apache.airavata.registry.core.replica.catalog.model.DataReplicaLocation;
import org.apache.airavata.registry.core.replica.catalog.utils.ReplicaCatalogJPAUtils;
import org.apache.airavata.registry.core.replica.catalog.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.ReplicaCatalog;
import org.apache.airavata.registry.cpi.ReplicaCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaCatalogImpl
implements ReplicaCatalog {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaCatalogImpl.class);

    public String registerDataProduct(DataProductModel productModel) throws ReplicaCatalogException {
        if (productModel.getOwnerName() == null || productModel.getGatewayId() == null) {
            throw new ReplicaCatalogException("owner name and gateway id should be non empty");
        }
        if (!(productModel.getParentProductUri() == null || this.isExists(productModel.getParentProductUri()) && this.getDataProduct(productModel.getParentProductUri()).getDataProductType().equals((Object)DataProductType.COLLECTION))) {
            throw new ReplicaCatalogException("Parent Product does not exists or parent type is not Collection");
        }
        long currentTime = System.currentTimeMillis();
        String productUri = "airavata-dp://" + UUID.randomUUID().toString();
        productModel.setProductUri(productUri);
        productModel.setCreationTime(currentTime);
        productModel.setLastModifiedTime(currentTime);
        if (productModel.getReplicaLocations() != null) {
            productModel.getReplicaLocations().stream().forEach(r -> {
                r.setProductUri(productUri);
                r.setReplicaId(UUID.randomUUID().toString());
                r.setCreationTime(currentTime);
                r.setLastModifiedTime(currentTime);
            });
        }
        productModel.setCreationTime(System.currentTimeMillis());
        productModel.setLastModifiedTime(System.currentTimeMillis());
        return this.createDataProduct(productModel);
    }

    private String createDataProduct(DataProductModel productModel) throws ReplicaCatalogException {
        DataProduct dataProduct = ThriftDataModelConversion.getDataProduct(productModel);
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            em.persist((Object)dataProduct);
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return dataProduct.getProductUri();
    }

    public boolean removeDataProduct(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            if (dataProduct == null) {
                boolean bl = false;
                return bl;
            }
            em.getTransaction().begin();
            em.remove((Object)dataProduct);
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return true;
    }

    public boolean updateDataProduct(DataProductModel productModel) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productModel.getProductUri());
            if (dataProduct == null) {
                boolean bl = false;
                return bl;
            }
            em.getTransaction().begin();
            productModel.setCreationTime(dataProduct.getCreationTime().getTime());
            productModel.setLastModifiedTime(System.currentTimeMillis());
            em.merge((Object)ThriftDataModelConversion.getUpdatedDataProduct(productModel, dataProduct));
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return true;
    }

    public DataProductModel getDataProduct(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            DataProductModel dataProductModel = ThriftDataModelConversion.getDataProductModel(dataProduct);
            return dataProductModel;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public boolean isExists(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            boolean bl = dataProduct != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String registerReplicaLocation(DataReplicaLocationModel dataReplicaLocationModel) throws ReplicaCatalogException {
        String replicaId = UUID.randomUUID().toString();
        dataReplicaLocationModel.setReplicaId(replicaId);
        long currentTime = System.currentTimeMillis();
        dataReplicaLocationModel.setCreationTime(currentTime);
        dataReplicaLocationModel.setLastModifiedTime(currentTime);
        dataReplicaLocationModel.setCreationTime(System.currentTimeMillis());
        dataReplicaLocationModel.setLastModifiedTime(System.currentTimeMillis());
        DataReplicaLocation replicaLocation = ThriftDataModelConversion.getDataReplicaLocation(dataReplicaLocationModel);
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            em.persist((Object)replicaLocation);
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return replicaId;
    }

    public boolean removeReplicaLocation(String replicaId) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataReplicaLocation replicaLocation = (DataReplicaLocation)em.find(DataReplicaLocation.class, (Object)replicaId);
            if (replicaLocation == null) {
                boolean bl = false;
                return bl;
            }
            em.getTransaction().begin();
            em.remove((Object)replicaLocation);
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return true;
    }

    public boolean updateReplicaLocation(DataReplicaLocationModel dataReplicaLocationModel) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataReplicaLocation dataReplicaLocation = (DataReplicaLocation)em.find(DataReplicaLocation.class, (Object)dataReplicaLocationModel.getReplicaId());
            if (dataReplicaLocation == null) {
                boolean bl = false;
                return bl;
            }
            em.getTransaction().begin();
            dataReplicaLocationModel.setCreationTime(dataReplicaLocation.getCreationTime().getTime());
            dataReplicaLocationModel.setLastModifiedTime(System.currentTimeMillis());
            em.merge((Object)ThriftDataModelConversion.getUpdatedDataReplicaLocation(dataReplicaLocationModel, dataReplicaLocation));
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return true;
    }

    public DataReplicaLocationModel getReplicaLocation(String replicaId) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataReplicaLocation replicaLocation = (DataReplicaLocation)em.find(DataReplicaLocation.class, (Object)replicaId);
            DataReplicaLocationModel dataReplicaLocationModel = ThriftDataModelConversion.getDataReplicaLocationModel(replicaLocation);
            return dataReplicaLocationModel;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<DataReplicaLocationModel> getAllReplicaLocations(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            if (dataProduct == null) {
                List<DataReplicaLocationModel> list = null;
                return list;
            }
            ArrayList<DataReplicaLocationModel> dataReplicaLocationModels = new ArrayList<DataReplicaLocationModel>();
            dataProduct.getDataReplicaLocations().stream().forEach(rl -> dataReplicaLocationModels.add(ThriftDataModelConversion.getDataReplicaLocationModel(rl)));
            ArrayList<DataReplicaLocationModel> arrayList = dataReplicaLocationModels;
            return arrayList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public DataProductModel getParentDataProduct(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            DataProductModel dataProductModel = ThriftDataModelConversion.getDataProductModel(dataProduct.getParentDataProduct());
            return dataProductModel;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<DataProductModel> getChildDataProducts(String productUri) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            em = ReplicaCatalogJPAUtils.getEntityManager();
            DataProduct dataProduct = (DataProduct)em.find(DataProduct.class, (Object)productUri);
            Collection<DataProduct> childProducts = dataProduct.getChildDataProducts();
            ArrayList<DataProductModel> returnModels = new ArrayList<DataProductModel>();
            childProducts.stream().forEach(cp -> returnModels.add(ThriftDataModelConversion.getDataProductModel(cp)));
            ArrayList<DataProductModel> arrayList = returnModels;
            return arrayList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<DataProductModel> searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset) throws ReplicaCatalogException {
        EntityManager em = null;
        try {
            String query = "SELECT dp FROM DataProduct dp WHERE dp.gatewayId = '" + gatewayId + "' AND dp.ownerName='" + userId + "' AND dp.productName LIKE '%" + productName + "%' ORDER BY dp.creationTime DESC";
            em = ReplicaCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = offset >= 0 && limit >= 0 ? em.createQuery(query).setFirstResult(offset).setMaxResults(limit) : em.createQuery(query);
            ArrayList<DataProductModel> returnModels = new ArrayList<DataProductModel>();
            List resultList = q.getResultList();
            for (Object o : resultList) {
                DataProduct dataProduct = (DataProduct)o;
                returnModels.add(ThriftDataModelConversion.getDataProductModel(dataProduct));
            }
            em.getTransaction().commit();
            em.close();
            ArrayList<DataProductModel> arrayList = returnModels;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

