/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.api.service.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.WorkflowModel;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.data.movement.DMType;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.data.movement.GridFTPDataMovement;
import org.apache.airavata.model.data.movement.LOCALDataMovement;
import org.apache.airavata.model.data.movement.SCPDataMovement;
import org.apache.airavata.model.data.movement.UnicoreDataMovement;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataErrorType;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.AuthorizationException;
import org.apache.airavata.model.error.DuplicateEntryException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.error.ProjectNotFoundException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentSearchFields;
import org.apache.airavata.model.experiment.ExperimentStatistics;
import org.apache.airavata.model.experiment.ExperimentSummaryModel;
import org.apache.airavata.model.experiment.ProjectSearchFields;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.QueueStatusModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.Notification;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.registry.core.app.catalog.resources.CloudSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ScpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.SshJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ApplicationDeployment;
import org.apache.airavata.registry.cpi.ComputeResource;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExpCatParentDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogException;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.GwyResourceProfile;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ReplicaCatalog;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.apache.airavata.registry.cpi.UsrResourceProfile;
import org.apache.airavata.registry.cpi.WorkflowCatalog;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryServerHandler
implements RegistryService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServerHandler.class);
    private ExperimentCatalog experimentCatalog;
    private AppCatalog appCatalog;
    private ReplicaCatalog dataCatalog;
    private WorkflowCatalog workflowCatalog;

    public String getAPIVersion() throws RegistryServiceException, TException {
        return "0.17.0";
    }

    public boolean isUserExists(String gatewayId, String userName) throws RegistryServiceException, TException {
        try {
            return ExpCatResourceUtils.isUserExist((String)userName, (String)gatewayId);
        }
        catch (RegistryException e) {
            logger.error("Error while verifying user", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while verifying user. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<String> getAllUsersInGateway(String gatewayId) throws RegistryServiceException, TException {
        try {
            return ExpCatResourceUtils.getAllUsersInGateway((String)gatewayId);
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving users", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving users. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Gateway getGateway(String gatewayId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId)) {
                logger.error("Gateway does not exist in the system. Please provide a valid gateway ID...");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setMessage("Gateway does not exist in the system. Please provide a valid gateway ID...");
                throw exception;
            }
            Gateway gateway = (Gateway)this.experimentCatalog.get(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId);
            logger.debug("Airavata retrieved gateway with gateway id : " + gateway.getGatewayId());
            return gateway;
        }
        catch (RegistryException e) {
            logger.error("Error while getting the gateway", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while getting the gateway. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteGateway(String gatewayId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId)) {
                logger.error("Gateway does not exist in the system. Please provide a valid gateway ID...");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setMessage("Gateway does not exist in the system. Please provide a valid gateway ID...");
                throw exception;
            }
            this.experimentCatalog.remove(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId);
            logger.debug("Airavata deleted gateway with gateway id : " + gatewayId);
            return true;
        }
        catch (RegistryException e) {
            logger.error("Error while deleting the gateway", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting the gateway. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<Gateway> getAllGateways() throws RegistryServiceException, TException {
        try {
            ArrayList<Gateway> gateways = new ArrayList<Gateway>();
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            List list = this.experimentCatalog.get(ExperimentCatalogModelType.GATEWAY, null, null);
            for (Object gateway : list) {
                gateways.add((Gateway)gateway);
            }
            logger.debug("Airavata retrieved all available gateways...");
            return gateways;
        }
        catch (RegistryException e) {
            logger.error("Error while getting all the gateways", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while getting all the gateways. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean isGatewayExist(String gatewayId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            return this.experimentCatalog.isExist(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId);
        }
        catch (RegistryException e) {
            logger.error("Error while getting gateway", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while getting gateway. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteNotification(String gatewayId, String notificationId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            this.experimentCatalog.remove(ExperimentCatalogModelType.NOTIFICATION, (Object)notificationId);
            return true;
        }
        catch (RegistryException e) {
            logger.error("Error while deleting notification", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting notification. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Notification getNotification(String gatewayId, String notificationId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            return (Notification)this.experimentCatalog.get(ExperimentCatalogModelType.NOTIFICATION, (Object)notificationId);
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving notification", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retreiving notification. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<Notification> getAllNotifications(String gatewayId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            List objectList = this.experimentCatalog.get(ExperimentCatalogModelType.NOTIFICATION, null, (Object)gatewayId);
            ArrayList<Notification> notifications = new ArrayList<Notification>();
            for (Object o : objectList) {
                notifications.add((Notification)o);
            }
            return notifications;
        }
        catch (RegistryException e) {
            logger.error("Error while getting all notifications", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while getting all notifications. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Project getProject(String projectId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.PROJECT, (Object)projectId)) {
                logger.error("Project does not exist in the system. Please provide a valid project ID...");
                ProjectNotFoundException exception = new ProjectNotFoundException();
                exception.setMessage("Project does not exist in the system. Please provide a valid project ID...");
                throw exception;
            }
            logger.debug("Airavata retrieved project with project Id : " + projectId);
            Project project = (Project)this.experimentCatalog.get(ExperimentCatalogModelType.PROJECT, (Object)projectId);
            return project;
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving the project", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the project. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteProject(String projectId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.PROJECT, (Object)projectId)) {
                logger.error("Project does not exist in the system. Please provide a valid project ID...");
                ProjectNotFoundException exception = new ProjectNotFoundException();
                exception.setMessage("Project does not exist in the system. Please provide a valid project ID...");
                throw exception;
            }
            this.experimentCatalog.remove(ExperimentCatalogModelType.PROJECT, (Object)projectId);
            logger.debug("Airavata deleted project with project Id : " + projectId);
            return true;
        }
        catch (RegistryException e) {
            logger.error("Error while removing the project", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while removing the project. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<Project> getUserProjects(String gatewayId, String userName, int limit, int offset) throws RegistryServiceException, TException {
        if (!this.validateString(userName)) {
            logger.error("Username cannot be empty. Please provide a valid user..");
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Username cannot be empty. Please provide a valid user..");
            throw exception;
        }
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userName, (String)gatewayId)) {
                logger.warn("User does not exist in the system. Please provide a valid user..");
                return projects;
            }
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("owner", userName);
            filters.put("gateway_id", gatewayId);
            List list = this.experimentCatalog.search(ExperimentCatalogModelType.PROJECT, filters, limit, offset, (Object)"creationTime", ResultOrderType.DESC);
            if (list != null && !list.isEmpty()) {
                for (Object o : list) {
                    projects.add((Project)o);
                }
            }
            logger.debug("Airavata retrieved projects for user : " + userName + " and gateway id : " + gatewayId);
            return projects;
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving projects", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving projects. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ExperimentStatistics getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("gatewayId", gatewayId);
            filters.put("fromDate", fromTime + "");
            filters.put("toDate", toTime + "");
            if (userName != null) {
                filters.put("userName", userName);
            }
            if (applicationName != null) {
                filters.put("executionId", applicationName);
            }
            if (resourceHostName != null) {
                filters.put("resourceHostId", resourceHostName);
            }
            List results = this.experimentCatalog.search(ExperimentCatalogModelType.EXPERIMENT_STATISTICS, filters);
            logger.debug("Airavata retrieved experiments for gateway id : " + gatewayId + " between : " + AiravataUtils.getTime((long)fromTime) + " and " + AiravataUtils.getTime((long)toTime));
            return (ExperimentStatistics)results.get(0);
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiments", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving experiments. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ExperimentModel> getExperimentsInProject(String projectId, int limit, int offset) throws RegistryServiceException, TException {
        if (!this.validateString(projectId)) {
            logger.error("Project id cannot be empty. Please provide a valid project ID...");
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Project id cannot be empty. Please provide a valid project ID...");
            throw exception;
        }
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.PROJECT, (Object)projectId)) {
                logger.error("Project does not exist in the system. Please provide a valid project ID...");
                ProjectNotFoundException exception = new ProjectNotFoundException();
                exception.setMessage("Project does not exist in the system. Please provide a valid project ID...");
                throw exception;
            }
            ArrayList<ExperimentModel> experiments = new ArrayList<ExperimentModel>();
            List list = this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, "projectId", (Object)projectId, limit, offset, (Object)"creationTime", ResultOrderType.DESC);
            if (list != null && !list.isEmpty()) {
                for (Object o : list) {
                    experiments.add((ExperimentModel)o);
                }
            }
            logger.debug("Airavata retrieved experiments for project : " + projectId);
            return experiments;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiments", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the experiments. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ExperimentModel> getUserExperiments(String gatewayId, String userName, int limit, int offset) throws RegistryServiceException, TException {
        if (!this.validateString(userName)) {
            logger.error("Username cannot be empty. Please provide a valid user..");
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Username cannot be empty. Please provide a valid user..");
            throw exception;
        }
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        ArrayList<ExperimentModel> experiments = new ArrayList<ExperimentModel>();
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userName, (String)gatewayId)) {
                logger.warn("User does not exist in the system. Please provide a valid user..");
                return experiments;
            }
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            List list = this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, "userName", (Object)userName, limit, offset, (Object)"creationTime", ResultOrderType.DESC);
            if (list != null && !list.isEmpty()) {
                for (Object o : list) {
                    experiments.add((ExperimentModel)o);
                }
            }
            logger.debug("Airavata retrieved experiments for user : " + userName);
            return experiments;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiments", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the experiments. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteExperiment(String experimentId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId)) {
                throw new ExperimentNotFoundException("Requested experiment id " + experimentId + " does not exist in the system..");
            }
            ExperimentModel experimentModel = (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            if (((ExperimentStatus)experimentModel.getExperimentStatus().get(0)).getState() != ExperimentState.CREATED) {
                logger.error("Error while deleting the experiment");
                throw new ExperimentCatalogException("Experiment is not in CREATED state. Hence cannot deleted. ID:" + experimentId);
            }
            this.experimentCatalog.remove(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            logger.debug("Airavata removed experiment with experiment id : " + experimentId);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting the experiment", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting the experiment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ExperimentModel getExperiment(String airavataExperimentId) throws RegistryServiceException, TException {
        ExperimentModel experimentModel = this.getExperimentInternal(airavataExperimentId);
        return experimentModel;
    }

    public ExperimentModel getDetailedExperimentTree(String airavataExperimentId) throws RegistryServiceException, TException {
        try {
            ExperimentModel experimentModel = this.getExperimentInternal(airavataExperimentId);
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            List processObjects = this.experimentCatalog.get(ExperimentCatalogModelType.PROCESS, "experimentId", (Object)experimentModel.getExperimentId());
            ArrayList processList = new ArrayList();
            if (processObjects != null) {
                processObjects.stream().forEach(p -> {
                    ((ProcessModel)p).getTasks().stream().forEach(t -> {
                        try {
                            List jobObjects = this.experimentCatalog.get(ExperimentCatalogModelType.JOB, "taskId", (Object)t.getTaskId());
                            ArrayList jobList = new ArrayList();
                            if (jobObjects != null) {
                                jobObjects.stream().forEach(j -> jobList.add((JobModel)j));
                                Collections.sort(jobList, new Comparator<JobModel>(){

                                    @Override
                                    public int compare(JobModel o1, JobModel o2) {
                                        return (int)(o1.getCreationTime() - o2.getCreationTime());
                                    }
                                });
                                t.setJobs(jobList);
                            }
                        }
                        catch (RegistryException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    });
                    processList.add((ProcessModel)p);
                });
                experimentModel.setProcesses(processList);
            }
            logger.debug("Airavata retrieved detailed experiment with experiment id : " + airavataExperimentId);
            return experimentModel;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiment", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the experiment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ExperimentStatus getExperimentStatus(String airavataExperimentId) throws RegistryServiceException, TException {
        ExperimentStatus experimentStatus = this.getExperimentStatusInternal(airavataExperimentId);
        logger.debug("Airavata retrieved experiment status for experiment id : " + airavataExperimentId);
        return experimentStatus;
    }

    public List<OutputDataObjectType> getExperimentOutputs(String airavataExperimentId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Get experiment outputs failed, experiment {} doesn't exit.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            logger.debug("Airavata retrieved experiment outputs for experiment id : " + airavataExperimentId);
            return (List)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT_OUTPUT, (Object)airavataExperimentId);
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the experiment outputs", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the experiment outputs. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<OutputDataObjectType> getIntermediateOutputs(String airavataExperimentId) throws RegistryServiceException, TException {
        return null;
    }

    public Map<String, JobStatus> getJobStatuses(String airavataExperimentId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Error while retrieving job details, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            List processModels = this.experimentCatalog.get(ExperimentCatalogModelType.PROCESS, "experimentId", (Object)airavataExperimentId);
            HashMap<String, JobStatus> jobStatus = new HashMap<String, JobStatus>();
            if (processModels != null && !processModels.isEmpty()) {
                for (Object process : processModels) {
                    ProcessModel processModel = (ProcessModel)process;
                    List tasks = processModel.getTasks();
                    if (tasks == null || tasks.isEmpty()) continue;
                    for (TaskModel task : tasks) {
                        String taskId = task.getTaskId();
                        List jobs = this.experimentCatalog.get(ExperimentCatalogModelType.JOB, "taskId", (Object)taskId);
                        if (jobs == null || jobs.isEmpty()) continue;
                        for (Object jobObject : jobs) {
                            JobModel jobModel = (JobModel)jobObject;
                            String jobID = jobModel.getJobId();
                            List status = jobModel.getJobStatuses();
                            if (status == null || status.size() <= 0) continue;
                            jobStatus.put(jobID, (JobStatus)status.get(0));
                        }
                    }
                }
            }
            logger.debug("Airavata retrieved job statuses for experiment with experiment id : " + airavataExperimentId);
            return jobStatus;
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the job statuses", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the job statuses. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<JobModel> getJobDetails(String airavataExperimentId) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Error while retrieving job details, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            List processModels = this.experimentCatalog.get(ExperimentCatalogModelType.PROCESS, "experimentId", (Object)airavataExperimentId);
            ArrayList<JobModel> jobList = new ArrayList<JobModel>();
            if (processModels != null && !processModels.isEmpty()) {
                for (Object process : processModels) {
                    ProcessModel processModel = (ProcessModel)process;
                    List tasks = processModel.getTasks();
                    if (tasks == null || tasks.isEmpty()) continue;
                    for (TaskModel taskModel : tasks) {
                        String taskId = taskModel.getTaskId();
                        List jobs = this.experimentCatalog.get(ExperimentCatalogModelType.JOB, "taskId", (Object)taskId);
                        for (Object jobObject : jobs) {
                            jobList.add((JobModel)jobObject);
                        }
                    }
                }
            }
            logger.debug("Airavata retrieved job models for experiment with experiment id : " + airavataExperimentId);
            return jobList;
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the job details", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the job details. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ApplicationModule getApplicationModule(String appModuleId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ApplicationModule module = this.appCatalog.getApplicationInterface().getApplicationModule(appModuleId);
            logger.debug("Airavata retrieved application module with module id : " + appModuleId);
            return module;
        }
        catch (AppCatalogException e) {
            logger.error(appModuleId, (Object)"Error while retrieving application module...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the adding application module. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ApplicationModule> getAllAppModules(String gatewayId) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            List moduleList = this.appCatalog.getApplicationInterface().getAllApplicationModules(gatewayId);
            logger.debug("Airavata retrieved modules for gateway id : " + gatewayId);
            return moduleList;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving all application modules...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving all application modules. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteApplicationModule(String appModuleId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            logger.debug("Airavata deleted application module with module id : " + appModuleId);
            return this.appCatalog.getApplicationInterface().removeApplicationModule(appModuleId);
        }
        catch (AppCatalogException e) {
            logger.error(appModuleId, (Object)"Error while deleting application module...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting the application module. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ApplicationDeploymentDescription getApplicationDeployment(String appDeploymentId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ApplicationDeploymentDescription deployement = this.appCatalog.getApplicationDeployment().getApplicationDeployement(appDeploymentId);
            logger.debug("Airavata registered application deployment for deployment id : " + appDeploymentId);
            return deployement;
        }
        catch (AppCatalogException e) {
            logger.error(appDeploymentId, (Object)"Error while retrieving application deployment...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application deployment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteApplicationDeployment(String appDeploymentId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getApplicationDeployment().removeAppDeployment(appDeploymentId);
            logger.debug("Airavata removed application deployment with deployment id : " + appDeploymentId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(appDeploymentId, (Object)"Error while deleting application deployment...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting application deployment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ApplicationDeploymentDescription> getAllApplicationDeployments(String gatewayId) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            List deployements = this.appCatalog.getApplicationDeployment().getAllApplicationDeployements(gatewayId);
            logger.debug("Airavata retrieved application deployments for gateway id : " + gatewayId);
            return deployements;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving application deployments...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application deployments. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<String> getAppModuleDeployedResources(String appModuleId) throws RegistryServiceException, TException {
        try {
            ArrayList<String> appDeployments = new ArrayList<String>();
            this.appCatalog = RegistryFactory.getAppCatalog();
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("appModuleID", appModuleId);
            List applicationDeployments = this.appCatalog.getApplicationDeployment().getApplicationDeployements(filters);
            for (ApplicationDeploymentDescription description : applicationDeployments) {
                appDeployments.add(description.getAppDeploymentId());
            }
            logger.debug("Airavata retrieved application deployments for module id : " + appModuleId);
            return appDeployments;
        }
        catch (AppCatalogException e) {
            logger.error(appModuleId, (Object)"Error while retrieving application deployments...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application deployment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ApplicationInterfaceDescription getApplicationInterface(String appInterfaceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ApplicationInterfaceDescription interfaceDescription = this.appCatalog.getApplicationInterface().getApplicationInterface(appInterfaceId);
            logger.debug("Airavata retrieved application interface with interface id : " + appInterfaceId);
            return interfaceDescription;
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while retrieving application interface...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteApplicationInterface(String appInterfaceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            boolean removeApplicationInterface = this.appCatalog.getApplicationInterface().removeApplicationInterface(appInterfaceId);
            logger.debug("Airavata removed application interface with interface id : " + appInterfaceId);
            return removeApplicationInterface;
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while deleting application interface...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting application interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Map<String, String> getAllApplicationInterfaceNames(String gatewayId) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            List allApplicationInterfaces = this.appCatalog.getApplicationInterface().getAllApplicationInterfaces(gatewayId);
            HashMap<String, String> allApplicationInterfacesMap = new HashMap<String, String>();
            if (allApplicationInterfaces != null && !allApplicationInterfaces.isEmpty()) {
                for (ApplicationInterfaceDescription interfaceDescription : allApplicationInterfaces) {
                    allApplicationInterfacesMap.put(interfaceDescription.getApplicationInterfaceId(), interfaceDescription.getApplicationName());
                }
            }
            logger.debug("Airavata retrieved application interfaces for gateway id : " + gatewayId);
            return allApplicationInterfacesMap;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving application interfaces...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application interfaces. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ApplicationInterfaceDescription> getAllApplicationInterfaces(String gatewayId) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            List interfaces = this.appCatalog.getApplicationInterface().getAllApplicationInterfaces(gatewayId);
            logger.debug("Airavata retrieved application interfaces for gateway id : " + gatewayId);
            return interfaces;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving application interfaces...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application interfaces. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<InputDataObjectType> getApplicationInputs(String appInterfaceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            List applicationInputs = this.appCatalog.getApplicationInterface().getApplicationInputs(appInterfaceId);
            logger.debug("Airavata retrieved application inputs for application interface id : " + appInterfaceId);
            return applicationInputs;
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while retrieving application inputs...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving application inputs. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<OutputDataObjectType> getApplicationOutputs(String appInterfaceId) throws RegistryServiceException, TException {
        List<OutputDataObjectType> list = this.getApplicationOutputsInternal(appInterfaceId);
        logger.debug("Airavata retrieved application outputs for app interface id : " + appInterfaceId);
        return list;
    }

    public Map<String, String> getAvailableAppInterfaceComputeResources(String appInterfaceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ApplicationDeployment applicationDeployment = this.appCatalog.getApplicationDeployment();
            Map allComputeResources = this.appCatalog.getComputeResource().getAvailableComputeResourceIdList();
            HashMap<String, String> availableComputeResources = new HashMap<String, String>();
            ApplicationInterfaceDescription applicationInterface = this.appCatalog.getApplicationInterface().getApplicationInterface(appInterfaceId);
            HashMap<String, String> filters = new HashMap<String, String>();
            List applicationModules = applicationInterface.getApplicationModules();
            if (applicationModules != null && !applicationModules.isEmpty()) {
                for (String moduleId : applicationModules) {
                    filters.put("appModuleID", moduleId);
                    List applicationDeployments = applicationDeployment.getApplicationDeployements(filters);
                    for (ApplicationDeploymentDescription deploymentDescription : applicationDeployments) {
                        if (allComputeResources.get(deploymentDescription.getComputeHostId()) == null) continue;
                        availableComputeResources.put(deploymentDescription.getComputeHostId(), (String)allComputeResources.get(deploymentDescription.getComputeHostId()));
                    }
                }
            }
            logger.debug("Airavata retrieved available compute resources for application interface id : " + appInterfaceId);
            return availableComputeResources;
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while saving compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while saving compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ComputeResourceDescription getComputeResource(String computeResourceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResourceDescription computeResource = this.appCatalog.getComputeResource().getComputeResource(computeResourceId);
            logger.debug("Airavata retrieved compute resource with compute resource Id : " + computeResourceId);
            return computeResource;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while retrieving compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Map<String, String> getAllComputeResourceNames() throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            Map computeResourceIdList = this.appCatalog.getComputeResource().getAllComputeResourceIdList();
            logger.debug("Airavata retrieved all the available compute resources...");
            return computeResourceIdList;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving compute resource...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteComputeResource(String computeResourceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().removeComputeResource(computeResourceId);
            logger.debug("Airavata deleted compute resource with compute resource Id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while deleting compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public StorageResourceDescription getStorageResource(String storageResourceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            StorageResourceDescription storageResource = this.appCatalog.getStorageResource().getStorageResource(storageResourceId);
            logger.debug("Airavata retrieved storage resource with storage resource Id : " + storageResourceId);
            return storageResource;
        }
        catch (AppCatalogException e) {
            logger.error(storageResourceId, (Object)"Error while retrieving storage resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving storage resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public Map<String, String> getAllStorageResourceNames() throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            Map resourceIdList = this.appCatalog.getStorageResource().getAllStorageResourceIdList();
            logger.debug("Airavata retrieved storage resources list...");
            return resourceIdList;
        }
        catch (AppCatalogException e) {
            logger.error("Error while retrieving storage resource...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving storage resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteStorageResource(String storageResourceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getStorageResource().removeStorageResource(storageResourceId);
            logger.debug("Airavata deleted storage resource with storage resource Id : " + storageResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(storageResourceId, (Object)"Error while deleting storage resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting storage resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public LOCALSubmission getLocalJobSubmission(String jobSubmissionId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            LOCALSubmission localJobSubmission = this.appCatalog.getComputeResource().getLocalJobSubmission(jobSubmissionId);
            logger.debug("Airavata retrieved local job submission for job submission interface id: " + jobSubmissionId);
            return localJobSubmission;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving local job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public SSHJobSubmission getSSHJobSubmission(String jobSubmissionId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            SSHJobSubmission sshJobSubmission = this.appCatalog.getComputeResource().getSSHJobSubmission(jobSubmissionId);
            logger.debug("Airavata retrieved SSH job submission for job submission interface id: " + jobSubmissionId);
            return sshJobSubmission;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving SSH job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public UnicoreJobSubmission getUnicoreJobSubmission(String jobSubmissionId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            UnicoreJobSubmission unicoreJobSubmission = this.appCatalog.getComputeResource().getUNICOREJobSubmission(jobSubmissionId);
            logger.debug("Airavata retrieved UNICORE job submission for job submission interface id: " + jobSubmissionId);
            return unicoreJobSubmission;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving Unicore job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public CloudJobSubmission getCloudJobSubmission(String jobSubmissionId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            CloudJobSubmission cloudJobSubmission = this.appCatalog.getComputeResource().getCloudJobSubmission(jobSubmissionId);
            logger.debug("Airavata retrieved cloud job submission for job submission interface id: " + jobSubmissionId);
            return cloudJobSubmission;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving Cloud job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public LOCALDataMovement getLocalDataMovement(String dataMovementId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            LOCALDataMovement localDataMovement = this.appCatalog.getComputeResource().getLocalDataMovement(dataMovementId);
            logger.debug("Airavata retrieved local data movement with data movement id: " + dataMovementId);
            return localDataMovement;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving local data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public SCPDataMovement getSCPDataMovement(String dataMovementId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            SCPDataMovement scpDataMovement = this.appCatalog.getComputeResource().getSCPDataMovement(dataMovementId);
            logger.debug("Airavata retrieved SCP data movement with data movement id: " + dataMovementId);
            return scpDataMovement;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving SCP data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public UnicoreDataMovement getUnicoreDataMovement(String dataMovementId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            UnicoreDataMovement unicoreDataMovement = this.appCatalog.getComputeResource().getUNICOREDataMovement(dataMovementId);
            logger.debug("Airavata retrieved UNICORE data movement with data movement id: " + dataMovementId);
            return unicoreDataMovement;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving UNICORE data movement interface...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public GridFTPDataMovement getGridFTPDataMovement(String dataMovementId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            GridFTPDataMovement gridFTPDataMovement = this.appCatalog.getComputeResource().getGridFTPDataMovement(dataMovementId);
            logger.debug("Airavata retrieved GRIDFTP data movement with data movement id: " + dataMovementId);
            return gridFTPDataMovement;
        }
        catch (AppCatalogException e) {
            String errorMsg = "Error while retrieving GridFTP data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(errorMsg + e.getMessage());
            throw exception;
        }
    }

    public boolean changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder) throws RegistryServiceException, TException {
        return false;
    }

    public boolean changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder) throws RegistryServiceException, TException {
        return false;
    }

    public boolean changeJobSubmissionPriorities(Map<String, Integer> jobSubmissionPriorityMap) throws RegistryServiceException, TException {
        return false;
    }

    public boolean changeDataMovementPriorities(Map<String, Integer> dataMovementPriorityMap) throws RegistryServiceException, TException {
        return false;
    }

    public boolean deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().removeJobSubmissionInterface(computeResourceId, jobSubmissionInterfaceId);
            logger.debug("Airavata deleted job submission interface with interface id : " + jobSubmissionInterfaceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while deleting job submission interface...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting job submission interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ResourceJobManager getResourceJobManager(String resourceJobManagerId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            return this.appCatalog.getComputeResource().getResourceJobManager(resourceJobManagerId);
        }
        catch (AppCatalogException e) {
            logger.error(resourceJobManagerId, (Object)"Error while retrieving resource job manager...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving resource job manager. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteResourceJobManager(String resourceJobManagerId) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().deleteResourceJobManager(resourceJobManagerId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(resourceJobManagerId, (Object)"Error while deleting resource job manager...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting resource job manager. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteBatchQueue(String computeResourceId, String queueName) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().removeBatchQueue(computeResourceId, queueName);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while deleting batch queue...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting batch queue. More info : " + e.getMessage());
            throw exception;
        }
    }

    public GatewayResourceProfile getGatewayResourceProfile(String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            GatewayResourceProfile gatewayResourceProfile = gatewayProfile.getGatewayProfile(gatewayID);
            logger.debug("Airavata retrieved gateway profile with gateway id : " + gatewayID);
            return gatewayResourceProfile;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while retrieving gateway resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving gateway resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteGatewayResourceProfile(String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            gatewayProfile.removeGatewayResourceProfile(gatewayID);
            logger.debug("Airavata deleted gateway profile with gateway id : " + gatewayID);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while removing gateway resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while removing gateway resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public ComputeResourcePreference getGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            if (!gatewayProfile.isGatewayResourceProfileExists(gatewayID)) {
                logger.error(gatewayID, (Object)"Given gateway profile does not exist in the system. Please provide a valid gateway id...");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Given gateway profile does not exist in the system. Please provide a valid gateway id...");
                throw exception;
            }
            if (!computeResource.isComputeResourceExists(computeResourceId)) {
                logger.error(computeResourceId, (Object)"Given compute resource does not exist in the system. Please provide a valid compute resource id...");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Given compute resource does not exist in the system. Please provide a valid compute resource id...");
                throw exception;
            }
            ComputeResourcePreference computeResourcePreference = gatewayProfile.getComputeResourcePreference(gatewayID, computeResourceId);
            logger.debug("Airavata retrieved gateway compute resource preference with gateway id : " + gatewayID + " and for compute resoruce id : " + computeResourceId);
            return computeResourcePreference;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading gateway compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public StoragePreference getGatewayStoragePreference(String gatewayID, String storageId) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            if (!gatewayProfile.isGatewayResourceProfileExists(gatewayID)) {
                logger.error(gatewayID, (Object)"Given gateway profile does not exist in the system. Please provide a valid gateway id...");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Given gateway profile does not exist in the system. Please provide a valid gateway id...");
                throw exception;
            }
            StoragePreference storagePreference = gatewayProfile.getStoragePreference(gatewayID, storageId);
            logger.debug("Airavata retrieved storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageId);
            return storagePreference;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading gateway data storage preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ComputeResourcePreference> getAllGatewayComputeResourcePreferences(String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            return gatewayProfile.getGatewayProfile(gatewayID).getComputeResourcePreferences();
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preferences...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading gateway compute resource preferences. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<StoragePreference> getAllGatewayStoragePreferences(String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            return gatewayProfile.getGatewayProfile(gatewayID).getStoragePreferences();
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preferences...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading gateway data storage preferences. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<GatewayResourceProfile> getAllGatewayResourceProfiles() throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            return gatewayProfile.getAllGatewayProfiles();
        }
        catch (AppCatalogException e) {
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading retrieving all gateway profiles. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            return gatewayProfile.removeComputeResourcePreferenceFromGateway(gatewayID, computeResourceId);
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteGatewayStoragePreference(String gatewayID, String storageId) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            return gatewayProfile.removeDataStoragePreferenceFromGateway(gatewayID, storageId);
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway data storage preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<String> getAllWorkflows(String gatewayId) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            return this.getWorkflowCatalog().getAllWorkflows(gatewayId);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in retrieving all workflow template Ids.";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public WorkflowModel getWorkflow(String workflowTemplateId) throws RegistryServiceException, TException {
        try {
            return this.getWorkflowCatalog().getWorkflow(workflowTemplateId);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in retrieving the workflow " + workflowTemplateId + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public void deleteWorkflow(String workflowTemplateId) throws RegistryServiceException, TException {
        try {
            this.getWorkflowCatalog().deleteWorkflow(workflowTemplateId);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in deleting the workflow " + workflowTemplateId + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public String getWorkflowTemplateId(String workflowName) throws RegistryServiceException, TException {
        try {
            return this.getWorkflowCatalog().getWorkflowTemplateId(workflowName);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in retrieving the workflow template id for " + workflowName + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean isWorkflowExistWithName(String workflowName) throws RegistryServiceException, TException {
        try {
            return this.getWorkflowCatalog().isWorkflowExistWithName(workflowName);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in veriying the workflow for workflow name " + workflowName + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public DataProductModel getDataProduct(String productUri) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            DataProductModel dataProductModel = this.dataCatalog.getDataProduct(productUri);
            return dataProductModel;
        }
        catch (RegistryException e) {
            String msg = "Error in retreiving the data product " + productUri + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public DataProductModel getParentDataProduct(String productUri) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            DataProductModel dataProductModel = this.dataCatalog.getParentDataProduct(productUri);
            return dataProductModel;
        }
        catch (RegistryException e) {
            String msg = "Error in retreiving the parent data product for " + productUri + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<DataProductModel> getChildDataProducts(String productUri) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            List dataProductModels = this.dataCatalog.getChildDataProducts(productUri);
            return dataProductModels;
        }
        catch (RegistryException e) {
            String msg = "Error in retreiving the child products for " + productUri + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<DataProductModel> searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            List dataProductModels = this.dataCatalog.searchDataProductsByName(gatewayId, userId, productName, limit, offset);
            return dataProductModels;
        }
        catch (RegistryException e) {
            String msg = "Error in searching the data products for name " + productName + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerReplicaLocation(DataReplicaLocationModel replicaLocationModel) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            String replicaId = this.dataCatalog.registerReplicaLocation(replicaLocationModel);
            return replicaId;
        }
        catch (RegistryException e) {
            String msg = "Error in retreiving the replica " + replicaLocationModel.getReplicaName() + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerDataProduct(DataProductModel dataProductModel) throws RegistryServiceException, TException {
        try {
            this.dataCatalog = RegistryFactory.getReplicaCatalog();
            String productUrl = this.dataCatalog.registerDataProduct(dataProductModel);
            return productUrl;
        }
        catch (RegistryException e) {
            String msg = "Error in registering the data resource" + dataProductModel.getProductName() + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public void updateWorkflow(String workflowTemplateId, WorkflowModel workflow) throws RegistryServiceException, TException {
        try {
            this.getWorkflowCatalog().updateWorkflow(workflowTemplateId, workflow);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in updating the workflow " + workflow.getName() + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerWorkflow(String gatewayId, WorkflowModel workflow) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            return this.getWorkflowCatalog().registerWorkflow(workflow, gatewayId);
        }
        catch (WorkflowCatalogException e) {
            String msg = "Error in registering the workflow " + workflow.getName() + ".";
            logger.error(msg, (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateGatewayStoragePreference(String gatewayID, String storageId, StoragePreference storagePreference) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            GatewayResourceProfile profile = gatewayProfile.getGatewayProfile(gatewayID);
            List dataStoragePreferences = profile.getStoragePreferences();
            StoragePreference preferenceToRemove = null;
            for (StoragePreference preference : dataStoragePreferences) {
                if (!preference.getStorageResourceId().equals(storageId)) continue;
                preferenceToRemove = preference;
                break;
            }
            if (preferenceToRemove != null) {
                profile.getStoragePreferences().remove(preferenceToRemove);
            }
            profile.getStoragePreferences().add(storagePreference);
            gatewayProfile.updateGatewayResourceProfile(gatewayID, profile);
            logger.debug("Airavata updated storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway data storage preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, ComputeResourcePreference computeResourcePreference) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            GatewayResourceProfile profile = gatewayProfile.getGatewayProfile(gatewayID);
            List computeResourcePreferences = profile.getComputeResourcePreferences();
            ComputeResourcePreference preferenceToRemove = null;
            for (ComputeResourcePreference preference : computeResourcePreferences) {
                if (!preference.getComputeResourceId().equals(computeResourceId)) continue;
                preferenceToRemove = preference;
                break;
            }
            if (preferenceToRemove != null) {
                profile.getComputeResourcePreferences().remove(preferenceToRemove);
            }
            profile.getComputeResourcePreferences().add(computeResourcePreference);
            gatewayProfile.updateGatewayResourceProfile(gatewayID, profile);
            logger.debug("Airavata updated compute resource preference with gateway id : " + gatewayID + " and for compute resource id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean addGatewayStoragePreference(String gatewayID, String storageResourceId, StoragePreference dataStoragePreference) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            if (!gatewayProfile.isGatewayResourceProfileExists(gatewayID)) {
                throw new RegistryServiceException("Gateway resource profile '" + gatewayID + "' does not exist!!!");
            }
            GatewayResourceProfile profile = gatewayProfile.getGatewayProfile(gatewayID);
            dataStoragePreference.setStorageResourceId(storageResourceId);
            profile.addToStoragePreferences(dataStoragePreference);
            gatewayProfile.updateGatewayResourceProfile(gatewayID, profile);
            logger.debug("Airavata added storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while registering gateway resource profile preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering gateway resource profile preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, ComputeResourcePreference computeResourcePreference) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            if (!gatewayProfile.isGatewayResourceProfileExists(gatewayID)) {
                throw new RegistryServiceException("Gateway resource profile '" + gatewayID + "' does not exist!!!");
            }
            GatewayResourceProfile profile = gatewayProfile.getGatewayProfile(gatewayID);
            profile.addToComputeResourcePreferences(computeResourcePreference);
            gatewayProfile.updateGatewayResourceProfile(gatewayID, profile);
            logger.debug("Airavata added gateway compute resource preference with gateway id : " + gatewayID + " and for compute resource id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while registering gateway resource profile preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering gateway resource profile preference. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateGatewayResourceProfile(String gatewayID, GatewayResourceProfile gatewayResourceProfile) throws RegistryServiceException, TException {
        try {
            if (!this.isGatewayExistInternal(gatewayID)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            gatewayProfile.updateGatewayResourceProfile(gatewayID, gatewayResourceProfile);
            logger.debug("Airavata updated gateway profile with gateway id : " + gatewayID);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while updating gateway resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerGatewayResourceProfile(GatewayResourceProfile gatewayResourceProfile) throws RegistryServiceException, TException {
        try {
            if (!this.validateString(gatewayResourceProfile.getGatewayID())) {
                logger.error("Cannot create gateway profile with empty gateway id");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Cannot create gateway profile with empty gateway id");
                throw exception;
            }
            if (!this.isGatewayExistInternal(gatewayResourceProfile.getGatewayID())) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            GwyResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile();
            String resourceProfile = gatewayProfile.addGatewayResourceProfile(gatewayResourceProfile);
            logger.debug("Airavata registered gateway profile with gateway id : " + gatewayResourceProfile.getGatewayID());
            return resourceProfile;
        }
        catch (AppCatalogException e) {
            logger.error("Error while registering gateway resource profile...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering gateway resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateResourceJobManager(String resourceJobManagerId, ResourceJobManager updatedResourceJobManager) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().updateResourceJobManager(resourceJobManagerId, updatedResourceJobManager);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(resourceJobManagerId, (Object)"Error while updating resource job manager...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating resource job manager. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerResourceJobManager(ResourceJobManager resourceJobManager) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            return this.appCatalog.getComputeResource().addResourceJobManager(resourceJobManager);
        }
        catch (AppCatalogException e) {
            logger.error(resourceJobManager.getResourceJobManagerId(), (Object)"Error while adding resource job manager...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding resource job manager. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteDataMovementInterface(String resourceId, String dataMovementInterfaceId, DMType dmType) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            switch (dmType) {
                case COMPUTE_RESOURCE: {
                    this.appCatalog.getComputeResource().removeDataMovementInterface(resourceId, dataMovementInterfaceId);
                    logger.debug("Airavata deleted data movement interface with interface id : " + dataMovementInterfaceId);
                    return true;
                }
                case STORAGE_RESOURCE: {
                    this.appCatalog.getStorageResource().removeDataMovementInterface(resourceId, dataMovementInterfaceId);
                    logger.debug("Airavata deleted data movement interface with interface id : " + dataMovementInterfaceId);
                    return true;
                }
            }
            logger.error("Unsupported data movement type specifies.. Please provide the correct data movement type... ");
            return false;
        }
        catch (AppCatalogException e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while deleting data movement interface...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while deleting data movement interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateGridFTPDataMovementDetails(String dataMovementInterfaceId, GridFTPDataMovement gridFTPDataMovement) throws RegistryServiceException, TException {
        try {
            GridftpDataMovementResource movment = AppCatalogThriftConversion.getGridFTPDataMovementDescription((GridFTPDataMovement)gridFTPDataMovement);
            movment.setDataMovementInterfaceId(dataMovementInterfaceId);
            movment.save();
            logger.debug("Airavata updated GRIDFTP data movement with data movement id: " + dataMovementInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addGridFTPDataMovementDetails(String computeResourceId, DMType dmType, int priorityOrder, GridFTPDataMovement gridFTPDataMovement) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String addDataMovementInterface = this.addDataMovementInterface(computeResource, computeResourceId, dmType, computeResource.addGridFTPDataMovement(gridFTPDataMovement), DataMovementProtocol.GridFTP, priorityOrder);
            logger.debug("Airavata registered GridFTP data movement for resource Id: " + computeResourceId);
            return addDataMovementInterface;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateUnicoreDataMovementDetails(String dataMovementInterfaceId, UnicoreDataMovement unicoreDataMovement) throws RegistryServiceException, TException {
        try {
            UnicoreDataMovementResource movment = AppCatalogThriftConversion.getUnicoreDMResource((UnicoreDataMovement)unicoreDataMovement);
            movment.setDataMovementId(dataMovementInterfaceId);
            movment.save();
            logger.debug("Airavata updated UNICORE data movement with data movement id: " + dataMovementInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while updating unicore data movement to compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating unicore data movement to compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addUnicoreDataMovementDetails(String resourceId, DMType dmType, int priorityOrder, UnicoreDataMovement unicoreDataMovement) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String movementInterface = this.addDataMovementInterface(computeResource, resourceId, dmType, computeResource.addUnicoreDataMovement(unicoreDataMovement), DataMovementProtocol.UNICORE_STORAGE_SERVICE, priorityOrder);
            logger.debug("Airavata registered UNICORE data movement for resource Id: " + resourceId);
            return movementInterface;
        }
        catch (AppCatalogException e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateSCPDataMovementDetails(String dataMovementInterfaceId, SCPDataMovement scpDataMovement) throws RegistryServiceException, TException {
        try {
            ScpDataMovementResource movment = AppCatalogThriftConversion.getSCPDataMovementDescription((SCPDataMovement)scpDataMovement);
            movment.setDataMovementInterfaceId(dataMovementInterfaceId);
            movment.save();
            logger.debug("Airavata updated SCP data movement with data movement id: " + dataMovementInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addSCPDataMovementDetails(String resourceId, DMType dmType, int priorityOrder, SCPDataMovement scpDataMovement) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String movementInterface = this.addDataMovementInterface(computeResource, resourceId, dmType, computeResource.addScpDataMovement(scpDataMovement), DataMovementProtocol.SCP, priorityOrder);
            logger.debug("Airavata registered SCP data movement for resource Id: " + resourceId);
            return movementInterface;
        }
        catch (AppCatalogException e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateLocalDataMovementDetails(String dataMovementInterfaceId, LOCALDataMovement localDataMovement) throws RegistryServiceException, TException {
        try {
            LocalDataMovementResource movment = AppCatalogThriftConversion.getLocalDataMovement((LOCALDataMovement)localDataMovement);
            movment.setDataMovementInterfaceId(dataMovementInterfaceId);
            movment.save();
            logger.debug("Airavata updated local data movement with data movement id: " + dataMovementInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while updating local data movement interface..", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating local data movement interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addLocalDataMovementDetails(String resourceId, DMType dataMoveType, int priorityOrder, LOCALDataMovement localDataMovement) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String movementInterface = this.addDataMovementInterface(computeResource, resourceId, dataMoveType, computeResource.addLocalDataMovement(localDataMovement), DataMovementProtocol.LOCAL, priorityOrder);
            logger.debug("Airavata registered local data movement for resource Id: " + resourceId);
            return movementInterface;
        }
        catch (AppCatalogException e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding data movement interface to resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, UnicoreJobSubmission unicoreJobSubmission) throws RegistryServiceException, TException {
        try {
            UnicoreJobSubmissionResource submission = AppCatalogThriftConversion.getUnicoreJobSubmission((UnicoreJobSubmission)unicoreJobSubmission);
            submission.setjobSubmissionInterfaceId(jobSubmissionInterfaceId);
            submission.save();
            logger.debug("Airavata updated UNICORE job submission for job submission interface id: " + jobSubmissionInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, CloudJobSubmission sshJobSubmission) throws RegistryServiceException, TException {
        try {
            CloudSubmissionResource submission = AppCatalogThriftConversion.getCloudJobSubmission((CloudJobSubmission)sshJobSubmission);
            submission.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
            submission.save();
            logger.debug("Airavata updated Cloud job submission for job submission interface id: " + jobSubmissionInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, SSHJobSubmission sshJobSubmission) throws RegistryServiceException, TException {
        try {
            SshJobSubmissionResource submission = AppCatalogThriftConversion.getSSHJobSubmission((SSHJobSubmission)sshJobSubmission);
            submission.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
            submission.save();
            logger.debug("Airavata updated SSH job submission for job submission interface id: " + jobSubmissionInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, CloudJobSubmission cloudSubmission) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String submissionInterface = this.addJobSubmissionInterface(computeResource, computeResourceId, computeResource.addCloudJobSubmission(cloudSubmission), JobSubmissionProtocol.CLOUD, priorityOrder);
            logger.debug("Airavata registered Cloud job submission for compute resource id: " + computeResourceId);
            return submissionInterface;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, UnicoreJobSubmission unicoreJobSubmission) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String submissionInterface = this.addJobSubmissionInterface(computeResource, computeResourceId, computeResource.addUNICOREJobSubmission(unicoreJobSubmission), JobSubmissionProtocol.UNICORE, priorityOrder);
            logger.debug("Airavata registered UNICORE job submission for compute resource id: " + computeResourceId);
            return submissionInterface;
        }
        catch (AppCatalogException e) {
            logger.error("Error while adding job submission interface to resource compute resource...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, SSHJobSubmission sshJobSubmission) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String submissionDetails = this.addJobSubmissionInterface(computeResource, computeResourceId, computeResource.addSSHJobSubmission(sshJobSubmission), JobSubmissionProtocol.SSH_FORK, priorityOrder);
            logger.debug("Airavata registered Fork job submission for compute resource id: " + computeResourceId);
            return submissionDetails;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, SSHJobSubmission sshJobSubmission) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String submissionInterface = this.addJobSubmissionInterface(computeResource, computeResourceId, computeResource.addSSHJobSubmission(sshJobSubmission), JobSubmissionProtocol.SSH, priorityOrder);
            logger.debug("Airavata registered SSH job submission for compute resource id: " + computeResourceId);
            return submissionInterface;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateLocalSubmissionDetails(String jobSubmissionInterfaceId, LOCALSubmission localSubmission) throws RegistryServiceException, TException {
        try {
            LocalSubmissionResource submission = AppCatalogThriftConversion.getLocalJobSubmission((LOCALSubmission)localSubmission);
            submission.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
            submission.save();
            logger.debug("Airavata updated local job submission for job submission interface id: " + jobSubmissionInterfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addLocalSubmissionDetails(String computeResourceId, int priorityOrder, LOCALSubmission localSubmission) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            String submissionInterface = this.addJobSubmissionInterface(computeResource, computeResourceId, computeResource.addLocalJobSubmission(localSubmission), JobSubmissionProtocol.LOCAL, priorityOrder);
            logger.debug("Airavata added local job submission for compute resource id: " + computeResourceId);
            return submissionInterface;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateStorageResource(String storageResourceId, StorageResourceDescription storageResourceDescription) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getStorageResource().updateStorageResource(storageResourceId, storageResourceDescription);
            logger.debug("Airavata updated storage resource with storage resource Id : " + storageResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(storageResourceId, (Object)"Error while updating storage resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updaing storage resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerStorageResource(StorageResourceDescription storageResourceDescription) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            String storageResource = this.appCatalog.getStorageResource().addStorageResource(storageResourceDescription);
            logger.debug("Airavata registered storage resource with storage resource Id : " + storageResource);
            return storageResource;
        }
        catch (AppCatalogException e) {
            logger.error("Error while saving storage resource...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while saving storage resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateComputeResource(String computeResourceId, ComputeResourceDescription computeResourceDescription) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getComputeResource().updateComputeResource(computeResourceId, computeResourceDescription);
            logger.debug("Airavata updated compute resource with compute resource Id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(computeResourceId, (Object)"Error while updating compute resource...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updaing compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerComputeResource(ComputeResourceDescription computeResourceDescription) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            String computeResource = this.appCatalog.getComputeResource().addComputeResource(computeResourceDescription);
            logger.debug("Airavata registered compute resource with compute resource Id : " + computeResource);
            return computeResource;
        }
        catch (AppCatalogException e) {
            logger.error("Error while saving compute resource...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while saving compute resource. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateApplicationInterface(String appInterfaceId, ApplicationInterfaceDescription applicationInterface) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getApplicationInterface().updateApplicationInterface(appInterfaceId, applicationInterface);
            logger.debug("Airavata updated application interface with interface id : " + appInterfaceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while updating application interface...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating application interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerApplicationInterface(String gatewayId, ApplicationInterfaceDescription applicationInterface) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            String interfaceId = this.appCatalog.getApplicationInterface().addApplicationInterface(applicationInterface, gatewayId);
            logger.debug("Airavata registered application interface for gateway id : " + gatewayId);
            return interfaceId;
        }
        catch (AppCatalogException e) {
            logger.error("Error while adding application interface...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding application interface. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateApplicationDeployment(String appDeploymentId, ApplicationDeploymentDescription applicationDeployment) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getApplicationDeployment().updateApplicationDeployment(appDeploymentId, applicationDeployment);
            logger.debug("Airavata updated application deployment for deployment id : " + appDeploymentId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(appDeploymentId, (Object)"Error while updating application deployment...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating application deployment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerApplicationDeployment(String gatewayId, ApplicationDeploymentDescription applicationDeployment) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            String deployment = this.appCatalog.getApplicationDeployment().addApplicationDeployment(applicationDeployment, gatewayId);
            logger.debug("Airavata registered application deployment for gateway id : " + gatewayId);
            return deployment;
        }
        catch (AppCatalogException e) {
            logger.error("Error while adding application deployment...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding application deployment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateApplicationModule(String appModuleId, ApplicationModule applicationModule) throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog.getApplicationInterface().updateApplicationModule(appModuleId, applicationModule);
            logger.debug("Airavata updated application module with module id: " + appModuleId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(appModuleId, (Object)"Error while updating application module...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating application module. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String registerApplicationModule(String gatewayId, ApplicationModule applicationModule) throws RegistryServiceException, TException {
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
        }
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            String module = this.appCatalog.getApplicationInterface().addApplicationModule(applicationModule, gatewayId);
            logger.debug("Airavata registered application module for gateway id : " + gatewayId);
            return module;
        }
        catch (AppCatalogException e) {
            logger.error("Error while adding application module...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding application module. More info : " + e.getMessage());
            throw exception;
        }
    }

    public void updateResourceScheduleing(String airavataExperimentId, ComputationalResourceSchedulingModel resourceScheduling) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.debug(airavataExperimentId, (Object)"Update resource scheduling failed, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            ExperimentStatus experimentStatus = this.getExperimentStatusInternal(airavataExperimentId);
            if (experimentStatus != null) {
                ExperimentState experimentState = experimentStatus.getState();
                switch (experimentState) {
                    case CREATED: 
                    case VALIDATED: 
                    case CANCELED: 
                    case FAILED: {
                        this.experimentCatalog.add(ExpCatChildDataType.PROCESS_RESOURCE_SCHEDULE, (Object)resourceScheduling, (Object)airavataExperimentId);
                        logger.debug(airavataExperimentId, (Object)"Successfully updated resource scheduling for the experiment {}.", (Object)airavataExperimentId);
                        break;
                    }
                    default: {
                        logger.error(airavataExperimentId, (Object)"Error while updating scheduling info. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ");
                        AiravataSystemException exception = new AiravataSystemException();
                        exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                        exception.setMessage("Error while updating experiment. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ");
                        throw exception;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while updating scheduling info", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating scheduling info. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses...  " + e.getMessage());
            throw exception;
        }
    }

    public void updateExperimentConfiguration(String airavataExperimentId, UserConfigurationDataModel userConfiguration) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Update experiment configuration failed, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            ExperimentStatus experimentStatus = this.getExperimentStatusInternal(airavataExperimentId);
            if (experimentStatus != null) {
                ExperimentState experimentState = experimentStatus.getState();
                switch (experimentState) {
                    case CREATED: 
                    case VALIDATED: 
                    case CANCELED: 
                    case FAILED: {
                        this.experimentCatalog.add(ExpCatChildDataType.USER_CONFIGURATION_DATA, (Object)userConfiguration, (Object)airavataExperimentId);
                        logger.debug(airavataExperimentId, (Object)"Successfully updated experiment configuration for experiment {}.", (Object)airavataExperimentId);
                        break;
                    }
                    default: {
                        logger.error(airavataExperimentId, (Object)"Error while updating experiment {}. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ", (Object)airavataExperimentId);
                        AiravataSystemException exception = new AiravataSystemException();
                        exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                        exception.setMessage("Error while updating experiment. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ");
                        throw exception;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while updating user configuration", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating user configuration. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses...  " + e.getMessage());
            throw exception;
        }
    }

    public void updateExperiment(String airavataExperimentId, ExperimentModel experiment) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Update request failed, Experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new RegistryServiceException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            ExperimentStatus experimentStatus = this.getExperimentStatusInternal(airavataExperimentId);
            if (experimentStatus != null) {
                ExperimentState experimentState = experimentStatus.getState();
                switch (experimentState) {
                    case CREATED: 
                    case VALIDATED: {
                        if (experiment.getUserConfigurationData() != null && experiment.getUserConfigurationData().getComputationalResourceScheduling() != null) {
                            String compResourceId = experiment.getUserConfigurationData().getComputationalResourceScheduling().getResourceHostId();
                            ComputeResourceDescription computeResourceDescription = this.appCatalog.getComputeResource().getComputeResource(compResourceId);
                            if (!computeResourceDescription.isEnabled()) {
                                logger.error("Compute Resource is not enabled by the Admin!");
                                AiravataSystemException exception = new AiravataSystemException();
                                exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                                exception.setMessage("Compute Resource is not enabled by the Admin!");
                                throw exception;
                            }
                        }
                        this.experimentCatalog.update(ExperimentCatalogModelType.EXPERIMENT, (Object)experiment, (Object)airavataExperimentId);
                        logger.debug(airavataExperimentId, (Object)"Successfully updated experiment {} ", (Object)experiment.getExperimentName());
                        break;
                    }
                    default: {
                        logger.error(airavataExperimentId, (Object)"Error while updating experiment. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ");
                        AiravataSystemException exception = new AiravataSystemException();
                        exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                        exception.setMessage("Error while updating experiment. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses... ");
                        throw exception;
                    }
                }
            }
        }
        catch (RegistryException e) {
            logger.error(airavataExperimentId, (Object)"Error while updating experiment", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating experiment. More info : " + e.getMessage());
            throw exception;
        }
        catch (AppCatalogException e) {
            logger.error(airavataExperimentId, (Object)"Error while updating experiment", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating experiment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String createExperiment(String gatewayId, ExperimentModel experiment) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            this.appCatalog = RegistryFactory.getAppCatalog();
            if (!this.validateString(experiment.getExperimentName())) {
                logger.error("Cannot create experiments with empty experiment name");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                exception.setMessage("Cannot create experiments with empty experiment name");
                throw exception;
            }
            if (!this.isGatewayExistInternal(gatewayId)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            if (experiment.getUserConfigurationData() != null && experiment.getUserConfigurationData().getComputationalResourceScheduling() != null) {
                String compResourceId = experiment.getUserConfigurationData().getComputationalResourceScheduling().getResourceHostId();
                ComputeResourceDescription computeResourceDescription = this.appCatalog.getComputeResource().getComputeResource(compResourceId);
                if (!computeResourceDescription.isEnabled()) {
                    logger.error("Compute Resource is not enabled by the Admin!");
                    AiravataSystemException exception = new AiravataSystemException();
                    exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                    exception.setMessage("Compute Resource is not enabled by the Admin!");
                    throw exception;
                }
            }
            String experimentId = (String)this.experimentCatalog.add(ExpCatParentDataType.EXPERIMENT, (Object)experiment, gatewayId);
            logger.debug(experimentId, (Object)"Created new experiment with experiment name {}", (Object)experiment.getExperimentName());
            return experimentId;
        }
        catch (Exception e) {
            logger.error("Error while creating the experiment with experiment name {}", (Object)experiment.getExperimentName());
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while creating the experiment. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<ExperimentSummaryModel> searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<ExperimentSearchFields, String> filters, int limit, int offset) throws RegistryServiceException, TException {
        if (!this.validateString(userName)) {
            logger.error("Username cannot be empty. Please provide a valid user..");
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Username cannot be empty. Please provide a valid user..");
            throw exception;
        }
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userName, (String)gatewayId)) {
                logger.error("User does not exist in the system. Please provide a valid user..");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                exception.setMessage("User does not exist in the system. Please provide a valid user..");
                throw exception;
            }
            ArrayList<ExperimentSummaryModel> summaries = new ArrayList<ExperimentSummaryModel>();
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            HashMap<String, String> regFilters = new HashMap<String, String>();
            regFilters.put("gatewayId", gatewayId);
            for (Map.Entry<ExperimentSearchFields, String> entry : filters.entrySet()) {
                if (entry.getKey().equals((Object)ExperimentSearchFields.EXPERIMENT_NAME)) {
                    regFilters.put("experimentName", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)ExperimentSearchFields.EXPERIMENT_DESC)) {
                    regFilters.put("description", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)ExperimentSearchFields.APPLICATION_ID)) {
                    regFilters.put("executionId", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)ExperimentSearchFields.STATUS)) {
                    regFilters.put("experimentStatus", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)ExperimentSearchFields.FROM_DATE)) {
                    regFilters.put("fromDate", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals((Object)ExperimentSearchFields.TO_DATE)) {
                    regFilters.put("toDate", entry.getValue());
                    continue;
                }
                if (!entry.getKey().equals((Object)ExperimentSearchFields.PROJECT_ID)) continue;
                regFilters.put("projectId", entry.getValue());
            }
            if (accessibleExpIds.size() == 0 && !ServerSettings.isEnableSharing().booleanValue() && !regFilters.containsKey("userName")) {
                regFilters.put("userName", userName);
            }
            List results = this.experimentCatalog.searchAllAccessible(ExperimentCatalogModelType.EXPERIMENT, accessibleExpIds, regFilters, limit, offset, (Object)"creationTime", ResultOrderType.DESC);
            for (Object object : results) {
                summaries.add((ExperimentSummaryModel)object);
            }
            logger.debug("Airavata retrieved experiments for user : " + userName + " and gateway id : " + gatewayId);
            return summaries;
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiments", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving experiments. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<Project> searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<ProjectSearchFields, String> filters, int limit, int offset) throws RegistryServiceException, TException {
        if (!this.validateString(userName)) {
            logger.error("Username cannot be empty. Please provide a valid user..");
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Username cannot be empty. Please provide a valid user..");
            throw exception;
        }
        if (!this.isGatewayExistInternal(gatewayId)) {
            logger.error("Gateway does not exist.Please provide a valid gateway id...");
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userName, (String)gatewayId)) {
                logger.error("User does not exist in the system. Please provide a valid user..");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
                exception.setMessage("User does not exist in the system. Please provide a valid user..");
                throw exception;
            }
            ArrayList<Project> projects = new ArrayList<Project>();
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            HashMap<String, String> regFilters = new HashMap<String, String>();
            regFilters.put("gateway_id", gatewayId);
            for (Map.Entry<ProjectSearchFields, String> entry : filters.entrySet()) {
                if (entry.getKey().equals((Object)ProjectSearchFields.PROJECT_NAME)) {
                    regFilters.put("name", entry.getValue());
                    continue;
                }
                if (!entry.getKey().equals((Object)ProjectSearchFields.PROJECT_DESCRIPTION)) continue;
                regFilters.put("description", entry.getValue());
            }
            if (accessibleProjIds.size() == 0 && !ServerSettings.isEnableSharing().booleanValue() && !regFilters.containsKey("userName")) {
                regFilters.put("userName", userName);
            }
            List results = this.experimentCatalog.searchAllAccessible(ExperimentCatalogModelType.PROJECT, accessibleProjIds, regFilters, limit, offset, (Object)"creationTime", ResultOrderType.DESC);
            for (Object object : results) {
                projects.add((Project)object);
            }
            logger.debug("Airavata retrieved projects for user : " + userName + " and gateway id : " + gatewayId);
            return projects;
        }
        catch (Exception e) {
            logger.error("Error while retrieving projects", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving projects. More info : " + e.getMessage());
            throw exception;
        }
    }

    public void updateProject(String projectId, Project updatedProject) throws RegistryServiceException, TException {
        if (!this.validateString(projectId) || !this.validateString(projectId)) {
            logger.error("Project id cannot be empty...");
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Project id cannot be empty...");
            throw exception;
        }
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)updatedProject.getGatewayId());
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.PROJECT, (Object)projectId)) {
                logger.error("Project does not exist in the system. Please provide a valid project ID...");
                ProjectNotFoundException exception = new ProjectNotFoundException();
                exception.setMessage("Project does not exist in the system. Please provide a valid project ID...");
                throw exception;
            }
            this.experimentCatalog.update(ExperimentCatalogModelType.PROJECT, (Object)updatedProject, (Object)projectId);
            logger.debug("Airavata updated project with project Id : " + projectId);
        }
        catch (RegistryException e) {
            logger.error("Error while updating the project", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating the project. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String createProject(String gatewayId, Project project) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            if (!this.validateString(project.getName()) || !this.validateString(project.getOwner())) {
                logger.error("Project name and owner cannot be empty...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            if (!this.validateString(gatewayId)) {
                logger.error("Gateway ID cannot be empty...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            if (!this.isGatewayExistInternal(gatewayId)) {
                logger.error("Gateway does not exist.Please provide a valid gateway id...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            String projectId = (String)this.experimentCatalog.add(ExpCatParentDataType.PROJECT, (Object)project, gatewayId);
            return projectId;
        }
        catch (Exception e) {
            logger.error("Error while creating the project", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while creating the project. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateNotification(Notification notification) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)notification.getGatewayId());
            this.experimentCatalog.update(ExperimentCatalogModelType.NOTIFICATION, (Object)notification, (Object)notification.getGatewayId());
            return true;
        }
        catch (RegistryException e) {
            logger.error("Error while updating notification", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while getting gateway. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String createNotification(Notification notification) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)notification.getGatewayId());
            return (String)this.experimentCatalog.add(ExpCatParentDataType.NOTIFICATION, (Object)notification, notification.getGatewayId());
        }
        catch (RegistryException e) {
            logger.error("Error while creating notification", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while creating notification. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateGateway(String gatewayId, Gateway updatedGateway) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId)) {
                logger.error("Gateway does not exist in the system. Please provide a valid gateway ID...");
                AiravataSystemException exception = new AiravataSystemException();
                exception.setMessage("Gateway does not exist in the system. Please provide a valid gateway ID...");
                throw exception;
            }
            this.experimentCatalog.update(ExperimentCatalogModelType.GATEWAY, (Object)updatedGateway, (Object)gatewayId);
            GatewayResourceProfile existingGwyResourceProfile = this.appCatalog.getGatewayProfile().getGatewayProfile(gatewayId);
            if (existingGwyResourceProfile.getIdentityServerPwdCredToken() == null || !existingGwyResourceProfile.getIdentityServerPwdCredToken().equals(updatedGateway.getIdentityServerPasswordToken())) {
                existingGwyResourceProfile.setIdentityServerPwdCredToken(updatedGateway.getIdentityServerPasswordToken());
                this.appCatalog.getGatewayProfile().updateGatewayResourceProfile(gatewayId, existingGwyResourceProfile);
            }
            logger.debug("Airavata update gateway with gateway id : " + gatewayId);
            return true;
        }
        catch (RegistryException e) {
            logger.error("Error while updating the gateway", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating the gateway. More info : " + e.getMessage());
            throw exception;
        }
        catch (AppCatalogException e) {
            logger.error("Error while updating gateway profile", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addGateway(Gateway gateway) throws RegistryServiceException, DuplicateEntryException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            this.appCatalog = RegistryFactory.getAppCatalog();
            if (!this.validateString(gateway.getGatewayId())) {
                logger.error("Gateway id cannot be empty...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            if (this.isGatewayExist(gateway.getGatewayId())) {
                throw new DuplicateEntryException("Gateway with gatewayId: " + gateway.getGatewayId() + ", already exists in ExperimentCatalog.");
            }
            if (this.appCatalog.getGatewayProfile().isGatewayResourceProfileExists(gateway.getGatewayId())) {
                throw new DuplicateEntryException("GatewayResourceProfile with gatewayId: " + gateway.getGatewayId() + ", already exists in AppCatalog.");
            }
            String gatewayId = (String)this.experimentCatalog.add(ExpCatParentDataType.GATEWAY, (Object)gateway, gateway.getGatewayId());
            GatewayResourceProfile gatewayResourceProfile = new GatewayResourceProfile();
            gatewayResourceProfile.setGatewayID(gatewayId);
            gatewayResourceProfile.setIdentityServerTenant(gatewayId);
            gatewayResourceProfile.setIdentityServerPwdCredToken(gateway.getIdentityServerPasswordToken());
            this.appCatalog.getGatewayProfile().addGatewayResourceProfile(gatewayResourceProfile);
            logger.debug("Airavata added gateway with gateway id : " + gateway.getGatewayId());
            return gatewayId;
        }
        catch (RegistryException e) {
            logger.error("Error while adding gateway", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding gateway. More info : " + e.getMessage());
            throw exception;
        }
        catch (AppCatalogException e) {
            logger.error("Error while adding gateway profile", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while adding gateway profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    private boolean validateString(String name) {
        boolean valid = true;
        if (name == null || name.equals("") || name.trim().length() == 0) {
            valid = false;
        }
        return valid;
    }

    private boolean isGatewayExistInternal(String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)gatewayId);
            return this.experimentCatalog.isExist(ExperimentCatalogModelType.GATEWAY, (Object)gatewayId);
        }
        catch (RegistryException e) {
            logger.error("Error while getting gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting gateway. More info : " + e.getMessage());
            throw exception;
        }
    }

    private ExperimentModel getExperimentInternal(String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            return (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId);
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving the experiment", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving the experiment. More info : " + e.getMessage());
            throw exception;
        }
    }

    private ExperimentStatus getExperimentStatusInternal(String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            if (!this.experimentCatalog.isExist(ExperimentCatalogModelType.EXPERIMENT, (Object)airavataExperimentId)) {
                logger.error(airavataExperimentId, (Object)"Error while retrieving experiment status, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            return (ExperimentStatus)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT_STATUS, (Object)airavataExperimentId);
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the experiment status", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the experiment status. More info : " + e.getMessage());
            throw exception;
        }
    }

    private List<OutputDataObjectType> getApplicationOutputsInternal(String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            return this.appCatalog.getApplicationInterface().getApplicationOutputs(appInterfaceId);
        }
        catch (AppCatalogException e) {
            logger.error(appInterfaceId, (Object)"Error while retrieving application outputs...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application outputs. More info : " + e.getMessage());
            throw exception;
        }
    }

    private String addJobSubmissionInterface(ComputeResource computeResource, String computeResourceId, String jobSubmissionInterfaceId, JobSubmissionProtocol protocolType, int priorityOrder) throws AppCatalogException {
        JobSubmissionInterface jobSubmissionInterface = new JobSubmissionInterface();
        jobSubmissionInterface.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        jobSubmissionInterface.setPriorityOrder(priorityOrder);
        jobSubmissionInterface.setJobSubmissionProtocol(protocolType);
        return computeResource.addJobSubmissionProtocol(computeResourceId, jobSubmissionInterface);
    }

    private String addDataMovementInterface(ComputeResource computeResource, String computeResourceId, DMType dmType, String dataMovementInterfaceId, DataMovementProtocol protocolType, int priorityOrder) throws AppCatalogException {
        DataMovementInterface dataMovementInterface = new DataMovementInterface();
        dataMovementInterface.setDataMovementInterfaceId(dataMovementInterfaceId);
        dataMovementInterface.setPriorityOrder(priorityOrder);
        dataMovementInterface.setDataMovementProtocol(protocolType);
        return computeResource.addDataMovementProtocol(computeResourceId, dmType, dataMovementInterface);
    }

    private WorkflowCatalog getWorkflowCatalog() {
        if (this.workflowCatalog == null) {
            try {
                this.workflowCatalog = RegistryFactory.getAppCatalog().getWorkflowCatalog();
            }
            catch (Exception e) {
                logger.error("Unable to create Workflow Catalog", (Throwable)e);
            }
        }
        return this.workflowCatalog;
    }

    public String registerUserResourceProfile(UserResourceProfile userResourceProfile) throws RegistryServiceException, TException {
        try {
            if (!this.validateString(userResourceProfile.getUserId())) {
                logger.error("Cannot create user resource profile with empty user id");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Cannot create user resource profile with empty gateway id");
                throw exception;
            }
            if (!this.validateString(userResourceProfile.getGatewayID())) {
                logger.error("Cannot create user resource profile with empty gateway id");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Cannot create user resource profile with empty gateway id");
                throw exception;
            }
            if (!ExpCatResourceUtils.isUserExist((String)userResourceProfile.getUserId(), (String)userResourceProfile.getGatewayID())) {
                logger.error("User does not exist.Please provide a valid user ID...");
                throw new RegistryServiceException("User does not exist.Please provide a valid user ID...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            String resourceProfile = userProfile.addUserResourceProfile(userResourceProfile);
            logger.debug("Airavata registered user resource profile with gateway id : " + userResourceProfile.getGatewayID() + "and user id : " + userResourceProfile.getUserId());
            return resourceProfile;
        }
        catch (AppCatalogException e) {
            logger.error("Error while registering user resource profile...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering user resource profile. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error("Error while registering user resource profile...", (Throwable)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public UserResourceProfile getUserResourceProfile(String userId, String gatewayId) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayId)) {
                logger.error("user does not exist.Please provide a valid gateway id...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile usrResourceProfile = this.appCatalog.getUserResourceProfile();
            UserResourceProfile userResourceProfile = usrResourceProfile.getUserResourceProfile(userId, gatewayId);
            logger.debug("Airavata retrieved User resource profile with user id : " + userId);
            return userResourceProfile;
        }
        catch (AppCatalogException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateUserResourceProfile(String userId, String gatewayID, UserResourceProfile userResourceProfile) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("User does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            userProfile.updateUserResourceProfile(userId, gatewayID, userResourceProfile);
            logger.debug("Airavata updated gateway profile with gateway id : " + userId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while updating gateway resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating gateway resource profile. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteUserResourceProfile(String userId, String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userResourceProfile = this.appCatalog.getUserResourceProfile();
            userResourceProfile.removeUserResourceProfile(userId, gatewayID);
            logger.debug("Airavata deleted User profile with gateway id : " + gatewayID + " and user id : " + userId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while removing User resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while removing User resource profile. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public String addUser(UserProfile userProfile) throws RegistryServiceException, DuplicateEntryException, TException {
        try {
            logger.info("Adding User in Registry: " + userProfile);
            if (this.isUserExists(userProfile.getGatewayId(), userProfile.getUserId())) {
                throw new DuplicateEntryException("User already exists, with userId: " + userProfile.getUserId() + ", and gatewayId: " + userProfile.getGatewayId());
            }
            ExpCatResourceUtils.addUser((String)userProfile.getUserId(), null, (String)userProfile.getGatewayId());
            return userProfile.getUserId();
        }
        catch (RegistryException ex) {
            logger.error("Error while adding user in registry: " + (Object)((Object)ex), (Throwable)ex);
            RegistryServiceException rse = new RegistryServiceException();
            rse.setMessage("Error while adding user in registry: " + ex.getMessage());
            throw rse;
        }
    }

    public boolean addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, UserComputeResourcePreference userComputeResourcePreference) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            if (!userProfile.isUserResourceProfileExists(userId, gatewayID)) {
                throw new RegistryServiceException("User resource profile with user id'" + userId + " &  gateway Id" + gatewayID + "' does not exist!!!");
            }
            UserResourceProfile profile = userProfile.getUserResourceProfile(userId, gatewayID);
            profile.addToUserComputeResourcePreferences(userComputeResourcePreference);
            userProfile.updateUserResourceProfile(userId, gatewayID, profile);
            logger.debug("Airavata added User compute resource preference with gateway id : " + gatewayID + " and for compute resource id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while registering User resource profile preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering user resource profile preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean addUserStoragePreference(String userId, String gatewayID, String storageResourceId, UserStoragePreference dataStoragePreference) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            if (!userProfile.isUserResourceProfileExists(userId, gatewayID)) {
                throw new RegistryServiceException("User resource profile with user id'" + userId + " &  gateway Id" + gatewayID + "' does not exist!!!");
            }
            UserResourceProfile profile = userProfile.getUserResourceProfile(userId, gatewayID);
            dataStoragePreference.setStorageResourceId(storageResourceId);
            profile.addToUserStoragePreferences(dataStoragePreference);
            userProfile.updateUserResourceProfile(userId, gatewayID, profile);
            logger.debug("Airavata added storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while registering user resource profile preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while registering user resource profile preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public UserComputeResourcePreference getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            if (!userProfile.isUserResourceProfileExists(userId, gatewayID)) {
                throw new RegistryServiceException("User resource profile with user id'" + userId + " &  gateway Id" + gatewayID + "' does not exist!!!");
            }
            ComputeResource computeResource = this.appCatalog.getComputeResource();
            if (!computeResource.isComputeResourceExists(userComputeResourceId)) {
                logger.error(userComputeResourceId, (Object)"Given compute resource does not exist in the system. Please provide a valid compute resource id...");
                RegistryServiceException exception = new RegistryServiceException();
                exception.setMessage("Given compute resource does not exist in the system. Please provide a valid compute resource id...");
                throw exception;
            }
            UserComputeResourcePreference userComputeResourcePreference = userProfile.getUserComputeResourcePreference(userId, gatewayID, userComputeResourceId);
            logger.debug("Airavata retrieved user compute resource preference with gateway id : " + gatewayID + " and for compute resoruce id : " + userComputeResourceId);
            return userComputeResourcePreference;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading user compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading user compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public UserStoragePreference getUserStoragePreference(String userId, String gatewayID, String storageId) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            if (!userProfile.isUserResourceProfileExists(userId, gatewayID)) {
                throw new RegistryServiceException("User resource profile with user id'" + userId + " &  gateway Id" + gatewayID + "' does not exist!!!");
            }
            UserStoragePreference storagePreference = userProfile.getUserStoragePreference(userId, gatewayID, storageId);
            logger.debug("Airavata retrieved user storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageId);
            return storagePreference;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading gateway data storage preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<UserResourceProfile> getAllUserResourceProfiles() throws RegistryServiceException, TException {
        try {
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            return userProfile.getAllUserResourceProfiles();
        }
        catch (AppCatalogException e) {
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading retrieving all gateway profiles. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, UserComputeResourcePreference userComputeResourcePreference) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            UserResourceProfile profile = userProfile.getUserResourceProfile(userId, gatewayID);
            List userComputeResourcePreferences = profile.getUserComputeResourcePreferences();
            UserComputeResourcePreference preferenceToRemove = null;
            for (UserComputeResourcePreference preference : userComputeResourcePreferences) {
                if (!preference.getComputeResourceId().equals(computeResourceId)) continue;
                preferenceToRemove = preference;
                break;
            }
            if (preferenceToRemove != null) {
                profile.getUserComputeResourcePreferences().remove(preferenceToRemove);
            }
            profile.getUserComputeResourcePreferences().add(userComputeResourcePreference);
            userProfile.updateUserResourceProfile(userId, gatewayID, profile);
            logger.debug("Airavata updated compute resource preference with gateway id : " + gatewayID + " and for compute resource id : " + computeResourceId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(userId, (Object)"Error while reading user compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating user compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean updateUserStoragePreference(String userId, String gatewayID, String storageId, UserStoragePreference userStoragePreference) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            UserResourceProfile profile = userProfile.getUserResourceProfile(userId, gatewayID);
            List dataStoragePreferences = profile.getUserStoragePreferences();
            UserStoragePreference preferenceToRemove = null;
            for (UserStoragePreference preference : dataStoragePreferences) {
                if (!preference.getStorageResourceId().equals(storageId)) continue;
                preferenceToRemove = preference;
                break;
            }
            if (preferenceToRemove != null) {
                profile.getUserStoragePreferences().remove(preferenceToRemove);
            }
            profile.getUserStoragePreferences().add(userStoragePreference);
            userProfile.updateUserResourceProfile(userId, gatewayID, profile);
            logger.debug("Airavata updated user storage resource preference with gateway id : " + gatewayID + " and for storage resource id : " + storageId);
            return true;
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading user data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating user data storage preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            return userProfile.removeUserComputeResourcePreferenceFromGateway(userId, gatewayID, computeResourceId);
        }
        catch (AppCatalogException e) {
            logger.error(userId, (Object)"Error while reading user compute resource preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating user compute resource preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean deleteUserStoragePreference(String userId, String gatewayID, String storageId) throws RegistryServiceException, TException {
        try {
            if (!ExpCatResourceUtils.isUserExist((String)userId, (String)gatewayID)) {
                logger.error("user does not exist.Please provide a valid user id...");
                throw new RegistryServiceException("user does not exist.Please provide a valid user id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            return userProfile.removeUserDataStoragePreferenceFromGateway(userId, gatewayID, storageId);
        }
        catch (AppCatalogException e) {
            logger.error(gatewayID, (Object)"Error while reading user data storage preference...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while updating user data storage preference. More info : " + e.getMessage());
            throw exception;
        }
        catch (RegistryException e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<QueueStatusModel> getLatestQueueStatuses() throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)ServerSettings.getDefaultUserGateway());
            List temp = this.experimentCatalog.get(ExperimentCatalogModelType.QUEUE_STATUS, null, null, -1, 0, null, null);
            ArrayList<QueueStatusModel> queueStatusModels = new ArrayList<QueueStatusModel>();
            temp.stream().forEach(t -> queueStatusModels.add((QueueStatusModel)t));
            return queueStatusModels;
        }
        catch (ApplicationSettingsException | RegistryException e) {
            logger.error("Error while reading queue status models....", e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading queue status models.... : " + e.getMessage());
            throw exception;
        }
    }

    public void registerQueueStatuses(List<QueueStatusModel> queueStatuses) throws RegistryServiceException, TException {
        try {
            this.experimentCatalog = RegistryFactory.getExperimentCatalog((String)ServerSettings.getDefaultUserGateway());
            this.experimentCatalog.add(ExpCatParentDataType.QUEUE_STATUS, queueStatuses, null);
        }
        catch (ApplicationSettingsException | RegistryException e) {
            logger.error("Error while storing queue status models....", e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while storing queue status models.... : " + e.getMessage());
            throw exception;
        }
    }

    public List<UserComputeResourcePreference> getAllUserComputeResourcePreferences(String userId, String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isUserExists(gatewayID, userId)) {
                logger.error("User Resource Profile does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("User Resource Profile does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            return userProfile.getUserResourceProfile(userId, gatewayID).getUserComputeResourcePreferences();
        }
        catch (AppCatalogException e) {
            logger.error(userId, (Object)"Error while reading User Resource Profile compute resource preferences...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading User Resource Profile compute resource preferences. More info : " + e.getMessage());
            throw exception;
        }
    }

    public List<UserStoragePreference> getAllUserStoragePreferences(String userId, String gatewayID) throws RegistryServiceException, TException {
        try {
            if (!this.isUserExists(gatewayID, userId)) {
                logger.error("User does not exist.Please provide a valid gateway id...");
                throw new RegistryServiceException("Gateway does not exist.Please provide a valid gateway id...");
            }
            this.appCatalog = RegistryFactory.getAppCatalog();
            UsrResourceProfile userProfile = this.appCatalog.getUserResourceProfile();
            return userProfile.getUserResourceProfile(userId, gatewayID).getUserStoragePreferences();
        }
        catch (AppCatalogException e) {
            logger.error(userId, (Object)"Error while reading user resource Profile data storage preferences...", (Object)e);
            RegistryServiceException exception = new RegistryServiceException();
            exception.setMessage("Error while reading user resource Profile data storage preferences. More info : " + e.getMessage());
            throw exception;
        }
    }
}

