/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class IdentityAuthorization
extends GSSAuthorization {
    private static Log logger = LogFactory.getLog((String)IdentityAuthorization.class.getName());
    protected String _identity;

    protected IdentityAuthorization() {
    }

    public IdentityAuthorization(String identity) {
        this.setIdentity(identity);
    }

    public void setIdentity(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        this._identity = identity;
    }

    public String getIdentity() {
        return this._identity;
    }

    public GSSName getExpectedName(GSSCredential cred, String host) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        return manager.createName(this._identity, null);
    }

    public void authorize(GSSContext context, String host) throws AuthorizationException {
        logger.debug((Object)"Authorization: IDENTITY");
        try {
            GSSName expected = this.getExpectedName(null, host);
            GSSName target = null;
            target = context.isInitiator() ? context.getTargName() : context.getSrcName();
            if (!expected.equals(target)) {
                this.generateAuthorizationException(expected, target);
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException("Authorization failure", e);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof IdentityAuthorization) {
            IdentityAuthorization other = (IdentityAuthorization)o;
            if (this._identity == null) {
                return other._identity == null;
            }
            return this._identity.equals(other._identity);
        }
        return false;
    }

    public int hashCode() {
        return this._identity == null ? 0 : this._identity.hashCode();
    }
}

