/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.cluster.AbstractRemoteCluster;
import org.apache.airavata.gfac.core.cluster.CommandInfo;
import org.apache.airavata.gfac.core.cluster.JobSubmissionOutput;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.gfac.impl.LocalCommandOutput;
import org.apache.airavata.gfac.impl.SSHUtils;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRemoteCluster
extends AbstractRemoteCluster {
    private static final Logger log = LoggerFactory.getLogger(LocalRemoteCluster.class);
    private static final int MAX_RETRY_COUNT = 3;

    public LocalRemoteCluster(ServerInfo serverInfo, JobManagerConfiguration jobManagerConfiguration, AuthenticationInfo authenticationInfo) {
        super(serverInfo, jobManagerConfiguration, authenticationInfo);
    }

    public JobSubmissionOutput submitBatchJob(String jobScriptFilePath, String workingDirectory) throws GFacException {
        try {
            JobSubmissionOutput jsoutput = new JobSubmissionOutput();
            this.copyTo(jobScriptFilePath, workingDirectory + File.separator + new File(jobScriptFilePath).getName());
            RawCommandInfo submitCommand = this.jobManagerConfiguration.getSubmitCommand(workingDirectory, jobScriptFilePath);
            submitCommand.setRawCommand(submitCommand.getRawCommand());
            LocalCommandOutput localCommandOutput = new LocalCommandOutput();
            this.executeCommand((CommandInfo)submitCommand, localCommandOutput);
            jsoutput.setJobId(this.outputParser.parseJobSubmission(localCommandOutput.getStandardOut()));
            jsoutput.setExitCode(localCommandOutput.getExitCode());
            jsoutput.setStdOut(localCommandOutput.getStandardOut());
            jsoutput.setStdErr(localCommandOutput.getStandardErrorString());
            return jsoutput;
        }
        catch (IOException e) {
            throw new GFacException("Error while submitting local batch job", (Throwable)e);
        }
    }

    public void copyTo(String localFile, String remoteFile) throws GFacException {
        Path sourcePath = Paths.get(localFile, new String[0]);
        Path targetPath = Paths.get(remoteFile, new String[0]);
        try {
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new GFacException("Error while copying sourceFile: " + sourcePath.toString() + ", to destinationFile: " + targetPath.toString(), (Throwable)e);
        }
    }

    public void copyFrom(String remoteFile, String localFile) throws GFacException {
        Path sourcePath = Paths.get(remoteFile, new String[0]);
        Path targetPath = Paths.get(localFile, new String[0]);
        try {
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new GFacException("Error while copying sourceFile: " + sourcePath.toString() + ", to destinationFile: " + targetPath.toString(), (Throwable)e);
        }
    }

    public void scpThirdParty(String sourceFile, Session srcSession, String destinationFile, Session destSession, RemoteCluster.DIRECTION inOrOut, boolean ignoreEmptyFile) throws GFacException {
        try {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                log.info("Transferring from:" + sourceFile + " To: " + destinationFile);
                try {
                    if (inOrOut == RemoteCluster.DIRECTION.TO) {
                        SSHUtils.scpThirdParty(sourceFile, srcSession, destinationFile, destSession, ignoreEmptyFile);
                    } else {
                        SSHUtils.scpThirdParty(sourceFile, srcSession, destinationFile, destSession, ignoreEmptyFile);
                    }
                    break;
                }
                catch (JSchException e) {
                    if (retryCount == 3) {
                        log.error("Retry count 3 exceeded for  transferring from:" + sourceFile + " To: " + destinationFile, (Throwable)e);
                        throw e;
                    }
                    log.error("Issue with jsch, Retry transferring from:" + sourceFile + " To: " + destinationFile, (Throwable)e);
                    continue;
                }
            }
        }
        catch (JSchException | IOException e) {
            throw new GFacException("Failed scp file:" + sourceFile + " to remote file " + destinationFile, e);
        }
    }

    public List<String> getFileNameFromExtension(String fileExtension, String parentPath, Session session) {
        throw new UnsupportedOperationException();
    }

    public void makeDirectory(String directoryPath) throws GFacException {
        Path dirPath = Paths.get(directoryPath, new String[0]);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        FileAttribute<Set<PosixFilePermission>> fileAttributes = PosixFilePermissions.asFileAttribute(perms);
        try {
            Files.createDirectory(dirPath, fileAttributes);
        }
        catch (IOException e) {
            throw new GFacException("Error making directory", (Throwable)e);
        }
    }

    public long getFileSize(String filePath) throws GFacException {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new GFacException(filePath + " is a directory. This does not support to measure the size of a directory");
            }
            return file.length();
        }
        throw new GFacException("File " + filePath + " does not exist");
    }

    public JobStatus cancelJob(String jobID) throws GFacException {
        JobStatus oldStatus = this.getJobStatus(jobID);
        RawCommandInfo cancelCommand = this.jobManagerConfiguration.getCancelCommand(jobID);
        this.execute((CommandInfo)cancelCommand);
        return oldStatus;
    }

    public JobStatus getJobStatus(String jobID) throws GFacException {
        RawCommandInfo monitorCommand = this.jobManagerConfiguration.getMonitorCommand(jobID);
        LocalCommandOutput localCommandOutput = new LocalCommandOutput();
        try {
            this.executeCommand((CommandInfo)monitorCommand, localCommandOutput);
            return this.outputParser.parseJobStatus(jobID, localCommandOutput.getStandardErrorString());
        }
        catch (IOException e) {
            throw new GFacException("Error while getting jobStatus", (Throwable)e);
        }
    }

    public String getJobIdByJobName(String jobName, String userName) throws GFacException {
        try {
            RawCommandInfo jobIdMonitorCommand = this.jobManagerConfiguration.getJobIdMonitorCommand(jobName, userName);
            LocalCommandOutput localCommandOutput = new LocalCommandOutput();
            this.executeCommand((CommandInfo)jobIdMonitorCommand, localCommandOutput);
            return this.outputParser.parseJobId(jobName, localCommandOutput.getStandardOut());
        }
        catch (IOException e) {
            throw new GFacException("Error while getting jobId using JobName", (Throwable)e);
        }
    }

    public void getJobStatuses(String userName, Map<String, JobStatus> jobStatusMap) throws GFacException {
        try {
            RawCommandInfo userBasedMonitorCommand = this.jobManagerConfiguration.getUserBasedMonitorCommand(userName);
            LocalCommandOutput localCommandOutput = new LocalCommandOutput();
            this.executeCommand((CommandInfo)userBasedMonitorCommand, localCommandOutput);
            this.outputParser.parseJobStatuses(userName, jobStatusMap, localCommandOutput.getStandardOut());
        }
        catch (IOException e) {
            throw new GFacException("Error while getting job statuses", (Throwable)e);
        }
    }

    public List<String> listDirectory(String directoryPath) throws GFacException {
        File[] files;
        File directory = new File(directoryPath);
        ArrayList<String> results = new ArrayList<String>();
        for (File file : files = directory.listFiles()) {
            results.add(file.getName());
        }
        return results;
    }

    public boolean execute(CommandInfo commandInfo) throws GFacException {
        LocalCommandOutput localCommandOutput = new LocalCommandOutput();
        try {
            this.executeCommand(commandInfo, localCommandOutput);
        }
        catch (IOException e) {
            throw new GFacException("Error while executing command " + commandInfo.getCommand(), (Throwable)e);
        }
        return true;
    }

    private void executeCommand(CommandInfo commandInfo, LocalCommandOutput localCommandOutput) throws IOException {
        Process process = Runtime.getRuntime().exec(commandInfo.getCommand());
        localCommandOutput.readOutputs(process);
    }

    public Session getSession() throws GFacException {
        return null;
    }

    public void disconnect() throws GFacException {
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public AuthenticationInfo getAuthentication() {
        return null;
    }
}

