/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.jsdl.extensions.ResourceRequestDocument;
import eu.unicore.jsdl.extensions.ResourceRequestType;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.JSDLUtils;
import org.apache.airavata.gfac.impl.task.utils.bes.RangeValueType;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class ResourceProcessor {
    public static void generateResourceElements(JobDefinitionType value, ProcessContext context) throws Exception {
        ProcessModel processModel = context.getProcessModel();
        if (processModel != null) {
            try {
                String qName;
                RangeValueType rangeType;
                ComputationalResourceSchedulingModel crs = processModel.getProcessResourceSchedule();
                if (crs.getTotalPhysicalMemory() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    rangeType.setExact(crs.getTotalPhysicalMemory());
                    JSDLUtils.setIndividualPhysicalMemoryRequirements(value, rangeType);
                }
                if (crs.getNodeCount() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    rangeType.setExact(crs.getNodeCount());
                    JSDLUtils.setTotalResourceCountRequirements(value, rangeType);
                }
                if (crs.getWallTimeLimit() > 0) {
                    RangeValueType cpuTime = new RangeValueType();
                    cpuTime.setLowerBound(Double.NaN);
                    cpuTime.setUpperBound(Double.NaN);
                    long wallTime = crs.getWallTimeLimit() * 60;
                    cpuTime.setExact(wallTime);
                    JSDLUtils.setIndividualCPUTimeRequirements(value, cpuTime);
                }
                if (crs.getTotalCPUCount() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    int nodeCount = crs.getNodeCount();
                    if (nodeCount <= 0) {
                        nodeCount = 1;
                    }
                    rangeType.setExact(crs.getTotalCPUCount() / nodeCount);
                    JSDLUtils.setIndividualCPUCountRequirements(value, rangeType);
                }
                if ((qName = crs.getQueueName()) != null && !"".equals(qName) && !crs.getQueueName().trim().equalsIgnoreCase("default")) {
                    ResourceRequestDocument rqDoc = ResourceRequestDocument.Factory.newInstance();
                    ResourceRequestType rq = rqDoc.addNewResourceRequest();
                    rq.setName("Queue");
                    rq.setValue(qName);
                    ResourcesType res = JSDLUtils.getOrCreateResources(value);
                    WSUtilities.insertAny((XmlObject)rqDoc, (XmlObject)res);
                }
            }
            catch (NullPointerException npe) {
                throw new Exception("No value set for resource requirements.", npe);
            }
        }
    }
}

