/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.watcher;

import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.watcher.RedeliveryRequestWatcher;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryRequestWatcherImpl
implements RedeliveryRequestWatcher {
    private static final Logger log = LoggerFactory.getLogger(RedeliveryRequestWatcherImpl.class);
    private final String processId;
    private final String experimentId;

    public RedeliveryRequestWatcherImpl(String experimentId, String procesId) {
        this.experimentId = experimentId;
        this.processId = procesId;
    }

    public void process(WatchedEvent watchedEvent) throws Exception {
        String path = watchedEvent.getPath();
        Watcher.Event.EventType eventType = watchedEvent.getType();
        log.info("Redelivery request came for zk path {} event type {} ", (Object)path, (Object)eventType.name());
        CuratorFramework curatorClient = Factory.getCuratorClient();
        switch (eventType) {
            case NodeDataChanged: {
                byte[] bytes = (byte[])curatorClient.getData().forPath(path);
                String serverName = new String(bytes);
                if (ServerSettings.getGFacServerName().trim().equals(serverName)) {
                    ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
                    log.info("processId: {},event type {}, change data with same server name : {}", new Object[]{this.processId, eventType, serverName});
                    break;
                }
                ProcessContext processContext = Factory.getGfacContext().getProcess(this.processId);
                if (processContext != null) {
                    processContext.setHandOver(true);
                    log.info("processId : {}, event type {}, handing over to new server instance : {}", new Object[]{this.processId, eventType, serverName});
                    break;
                }
                log.info("Redelivery request came for processId {}, with event type {}, but couldn't find process context", (Object)this.processId, (Object)eventType.name());
                break;
            }
            case NodeDeleted: {
                log.info("Redelivery watcher trigger for process {} with event type {}", (Object)this.processId, (Object)eventType.name());
                break;
            }
            case NodeCreated: 
            case NodeChildrenChanged: 
            case None: {
                if (path == null) break;
                ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
                log.info("Redelivery watcher trigger for process {} with event type {}", (Object)this.processId, (Object)eventType.name());
                break;
            }
            default: {
                if (path == null) break;
                ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
                log.info("Redelivery watcher trigger for process {} with event type {}", (Object)this.processId, (Object)eventType.name());
            }
        }
    }
}

