/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.cloud;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.airavata.cloud.aurora.client.AuroraThriftClient;
import org.apache.airavata.cloud.aurora.client.bean.JobDetailsResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.JobKeyBean;
import org.apache.airavata.cloud.aurora.client.sdk.ScheduledTask;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacThreadPoolExecutor;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.monitor.JobMonitor;
import org.apache.airavata.gfac.impl.GFacWorker;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuroraJobMonitor
implements JobMonitor,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(AuroraJobMonitor.class);
    private static AuroraJobMonitor auroraJobMonitor;
    private Timer timer;
    private Map<String, TaskContext> jobMonitoringMap = new ConcurrentHashMap<String, TaskContext>();

    private AuroraJobMonitor() {
        this.timer = new Timer("Aurora status poll timer", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuroraJobMonitor getInstance() {
        if (auroraJobMonitor != null) return auroraJobMonitor;
        Class<AuroraJobMonitor> clazz = AuroraJobMonitor.class;
        synchronized (AuroraJobMonitor.class) {
            if (auroraJobMonitor != null) return auroraJobMonitor;
            auroraJobMonitor = new AuroraJobMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return auroraJobMonitor;
        }
    }

    @Override
    public void run() {
        AuroraTimer task = null;
        try {
            task = new AuroraTimer();
            this.timer.schedule((TimerTask)task, 5000L, 5000L);
        }
        catch (Exception e) {
            log.error("Error couldn't run Aurora status poll timer task");
        }
    }

    public void monitor(String jobId, TaskContext taskContext) {
        this.jobMonitoringMap.put(jobId, taskContext);
        log.info("Added JobId : {} to Aurora Job Monitoring map", (Object)jobId);
        taskContext.getParentProcessContext().setPauseTaskExecution(true);
    }

    public void stopMonitor(String jobId, boolean runOutFlow) {
        this.jobMonitoringMap.remove(jobId);
    }

    public boolean isMonitoring(String jobId) {
        return this.jobMonitoringMap.get(jobId) != null;
    }

    public void canceledJob(String jobId) {
        throw new IllegalStateException("Method not yet implemented");
    }

    class AuroraTimer
    extends TimerTask {
        AuroraThriftClient client = AuroraThriftClient.getAuroraThriftClient();

        @Override
        public void run() {
            while (true) {
                JobKeyBean jobKeyBean = new JobKeyBean("devel", "centos", "dummy");
                Iterator iterator = AuroraJobMonitor.this.jobMonitoringMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry currentEntry = iterator.next();
                    try {
                        jobKeyBean.setName((String)currentEntry.getKey());
                        JobDetailsResponseBean jobDetailsResponseBean = this.client.getJobDetails(jobKeyBean);
                        List tasks = jobDetailsResponseBean.getTasks();
                        switch (((ScheduledTask)tasks.get(0)).getStatus()) {
                            case FINISHED: {
                                iterator.remove();
                                this.processJob((String)currentEntry.getKey(), (TaskContext)currentEntry.getValue(), JobState.COMPLETE);
                                break;
                            }
                            case FAILED: {
                                iterator.remove();
                                this.processJob((String)currentEntry.getKey(), (TaskContext)currentEntry.getValue(), JobState.FAILED);
                                break;
                            }
                            case RUNNING: {
                                this.updateStatus((String)currentEntry.getKey(), (TaskContext)currentEntry.getValue(), JobState.ACTIVE);
                                break;
                            }
                            default: {
                                log.info("Job {} is in {} state", currentEntry.getKey(), (Object)((ScheduledTask)tasks.get(0)).getStatus().name());
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Error while getting response for job : {}", currentEntry.getKey());
                    }
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn("Aurora Monitoring task interrupted");
                    continue;
                }
                break;
            }
        }

        private void updateStatus(String jobKey, TaskContext taskContext, JobState jobState) {
            ProcessContext pc = taskContext.getParentProcessContext();
            JobModel jobModel = pc.getJobModel();
            if (((JobStatus)jobModel.getJobStatuses().get(0)).getJobState() != jobState) {
                JobStatus jobStatus = new JobStatus(jobState);
                jobStatus.setReason("Aurora return " + jobState.name());
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                jobModel.setJobStatuses(Arrays.asList(jobStatus));
                try {
                    GFacUtils.saveJobStatus((ProcessContext)pc, (JobModel)jobModel);
                }
                catch (GFacException e) {
                    log.error("Error while saving job status {}, job : {}, task :{}, process:{} exp:{}", new Object[]{jobState.name(), jobKey, taskContext.getTaskId(), pc.getProcessId(), pc.getExperimentId()});
                }
            }
        }

        private void processJob(String jobKey, TaskContext taskContext, JobState jobState) {
            JobStatus jobStatus = new JobStatus();
            jobStatus.setJobState(jobState);
            if (jobState == JobState.COMPLETE) {
                jobStatus.setReason("Aurora Job completed");
            } else if (jobState == JobState.FAILED) {
                jobStatus.setReason("Aurora Job Failed");
            }
            ProcessContext pc = taskContext.getParentProcessContext();
            JobModel jobModel = pc.getJobModel();
            jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            jobModel.setJobStatuses(Arrays.asList(jobStatus));
            try {
                GFacUtils.saveJobStatus((ProcessContext)pc, (JobModel)jobModel);
            }
            catch (GFacException e) {
                log.error("Error while saving job status for job : {} ", (Object)jobKey);
            }
            TaskStatus taskStatus = new TaskStatus(TaskState.COMPLETED);
            taskStatus.setReason("Job monitoring completed with final state: " + TaskState.COMPLETED.name());
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(taskStatus);
            try {
                GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            }
            catch (GFacException e) {
                log.error("Error while saving task status for exp : {} , process : {} , task : {} , job : {}", new Object[]{taskContext.getExperimentId(), taskContext.getProcessId(), taskContext.getTaskId(), jobKey});
            }
            if (pc.isCancel()) {
                ProcessStatus processStatus = new ProcessStatus(ProcessState.CANCELLING);
                processStatus.setReason("Process has been cancelled");
                pc.setProcessStatus(processStatus);
                try {
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)pc);
                }
                catch (GFacException e) {
                    log.error("Error while cancelling process, exp : {}, process : {}", (Object)pc.getExperimentId(), (Object)pc.getProcessId());
                }
            }
            try {
                GFacThreadPoolExecutor.getCachedThreadPool().execute(new GFacWorker(pc));
            }
            catch (GFacException e) {
                log.error("Error while running output tasks for exp : {} , process : {}", (Object)taskContext.getExperimentId(), (Object)pc.getProcessId());
                ProcessStatus processStatus = new ProcessStatus(ProcessState.FAILED);
                processStatus.setReason("Failed to run output tasks");
                processStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                pc.setProcessStatus(processStatus);
                try {
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)pc);
                }
                catch (GFacException ex) {
                    log.error("Error while updating process status to FAILED, exp : {}, process : {}", (Object)pc.getExperimentId(), (Object)pc.getProcessId());
                }
            }
        }
    }
}

