/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SocketFrameHandler
implements FrameHandler {
    private final Socket _socket;
    private final DataInputStream _inputStream;
    private final DataOutputStream _outputStream;
    public static final int SOCKET_CLOSING_TIMEOUT = 1;

    public SocketFrameHandler(Socket socket) throws IOException {
        this._socket = socket;
        this._inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this._outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    @Override
    public InetAddress getAddress() {
        return this._socket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public DataInputStream getInputStream() {
        return this._inputStream;
    }

    @Override
    public int getPort() {
        return this._socket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    @Override
    public void setTimeout(int timeoutMs) throws SocketException {
        this._socket.setSoTimeout(timeoutMs);
    }

    @Override
    public int getTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int major, int minor) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(1);
            this._outputStream.write(1);
            this._outputStream.write(major);
            this._outputStream.write(minor);
            this._outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int major, int minor, int revision) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(0);
            this._outputStream.write(major);
            this._outputStream.write(minor);
            this._outputStream.write(revision);
            this._outputStream.flush();
        }
    }

    @Override
    public void sendHeader() throws IOException {
        this.sendHeader(0, 9, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame readFrame() throws IOException {
        DataInputStream dataInputStream = this._inputStream;
        synchronized (dataInputStream) {
            return Frame.readFrom(this._inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFrame(Frame frame) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            frame.writeTo(this._outputStream);
        }
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
    }

    @Override
    public void close() {
        try {
            this._socket.setSoLinger(true, 1);
        }
        catch (Exception _e) {
            // empty catch block
        }
        try {
            this.flush();
        }
        catch (Exception _e) {
            // empty catch block
        }
        try {
            this._socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

