/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.SignalExternalWorkflowExecutionDecisionAttributes;

class SignalDecisionStateMachine
extends DecisionStateMachineBase {
    private SignalExternalWorkflowExecutionDecisionAttributes attributes;
    private boolean canceled;

    public SignalDecisionStateMachine(DecisionId id, SignalExternalWorkflowExecutionDecisionAttributes attributes) {
        super(id);
        this.attributes = attributes;
    }

    SignalDecisionStateMachine(DecisionId id, SignalExternalWorkflowExecutionDecisionAttributes attributes, DecisionState state) {
        super(id, state);
        this.attributes = attributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createSignalExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.canceled;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CREATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.DECISION_SENT;
                this.stateHistory.add(this.state.toString());
            }
        }
    }

    @Override
    public void cancel(Runnable immediateCancellationCallback) {
        this.stateHistory.add("cancel");
        switch (this.state) {
            case CREATED: 
            case INITIATED: {
                this.state = DecisionState.COMPLETED;
                if (immediateCancellationCallback == null) break;
                immediateCancellationCallback.run();
                break;
            }
            case DECISION_SENT: {
                this.state = DecisionState.CANCELED_BEFORE_INITIATED;
                if (immediateCancellationCallback == null) break;
                immediateCancellationCallback.run();
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.canceled = true;
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        this.stateHistory.add("handleInitiatedEvent");
        switch (this.state) {
            case DECISION_SENT: {
                this.state = DecisionState.INITIATED;
                break;
            }
            case CANCELED_BEFORE_INITIATED: {
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCompletionEvent() {
        this.stateHistory.add("handleCompletionEvent");
        switch (this.state) {
            case DECISION_SENT: 
            case CANCELED_BEFORE_INITIATED: 
            case INITIATED: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            case COMPLETED: {
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationInitiatedEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationEvent() {
        throw new UnsupportedOperationException();
    }

    private Decision createSignalExternalWorkflowExecutionDecision() {
        Decision decision = new Decision();
        decision.setSignalExternalWorkflowExecutionDecisionAttributes(this.attributes);
        decision.setDecisionType(DecisionType.SignalExternalWorkflowExecution.toString());
        return decision;
    }
}

