/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeSecurityGroupsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSecurityGroupsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeSecurityGroupsRequest> {
    private ListWithAutoConstructFlag<String> groupNames;
    private ListWithAutoConstructFlag<String> groupIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ListWithAutoConstructFlag();
            this.groupNames.setAutoConstruct(true);
        }
        return this.groupNames;
    }

    public void setGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
            return;
        }
        ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
        groupNamesCopy.addAll(groupNames);
        this.groupNames = groupNamesCopy;
    }

    public DescribeSecurityGroupsRequest withGroupNames(String ... groupNames) {
        if (this.getGroupNames() == null) {
            this.setGroupNames(new ArrayList<String>(groupNames.length));
        }
        for (String value : groupNames) {
            this.getGroupNames().add(value);
        }
        return this;
    }

    public DescribeSecurityGroupsRequest withGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
        } else {
            ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
            groupNamesCopy.addAll(groupNames);
            this.groupNames = groupNamesCopy;
        }
        return this;
    }

    public List<String> getGroupIds() {
        if (this.groupIds == null) {
            this.groupIds = new ListWithAutoConstructFlag();
            this.groupIds.setAutoConstruct(true);
        }
        return this.groupIds;
    }

    public void setGroupIds(Collection<String> groupIds) {
        if (groupIds == null) {
            this.groupIds = null;
            return;
        }
        ListWithAutoConstructFlag groupIdsCopy = new ListWithAutoConstructFlag(groupIds.size());
        groupIdsCopy.addAll(groupIds);
        this.groupIds = groupIdsCopy;
    }

    public DescribeSecurityGroupsRequest withGroupIds(String ... groupIds) {
        if (this.getGroupIds() == null) {
            this.setGroupIds(new ArrayList<String>(groupIds.length));
        }
        for (String value : groupIds) {
            this.getGroupIds().add(value);
        }
        return this;
    }

    public DescribeSecurityGroupsRequest withGroupIds(Collection<String> groupIds) {
        if (groupIds == null) {
            this.groupIds = null;
        } else {
            ListWithAutoConstructFlag groupIdsCopy = new ListWithAutoConstructFlag(groupIds.size());
            groupIdsCopy.addAll(groupIds);
            this.groupIds = groupIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeSecurityGroupsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeSecurityGroupsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeSecurityGroupsRequest> getDryRunRequest() {
        Request<DescribeSecurityGroupsRequest> request = new DescribeSecurityGroupsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupNames() != null) {
            sb.append("GroupNames: " + this.getGroupNames() + ",");
        }
        if (this.getGroupIds() != null) {
            sb.append("GroupIds: " + this.getGroupIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupNames() == null ? 0 : this.getGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getGroupIds() == null ? 0 : this.getGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsRequest)) {
            return false;
        }
        DescribeSecurityGroupsRequest other = (DescribeSecurityGroupsRequest)obj;
        if (other.getGroupNames() == null ^ this.getGroupNames() == null) {
            return false;
        }
        if (other.getGroupNames() != null && !other.getGroupNames().equals(this.getGroupNames())) {
            return false;
        }
        if (other.getGroupIds() == null ^ this.getGroupIds() == null) {
            return false;
        }
        if (other.getGroupIds() != null && !other.getGroupIds().equals(this.getGroupIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

