/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedFieldsTracker {
    private final Map<Object, Map<Integer, Object>> mappedFields = new IdentityHashMap<Object, Map<Integer, Object>>();

    public void put(Object src, Object dest) {
        int destId = System.identityHashCode(dest);
        Map<Integer, Object> mappedTo = this.mappedFields.get(src);
        if (mappedTo == null) {
            mappedTo = new HashMap<Integer, Object>();
            this.mappedFields.put(src, mappedTo);
        }
        if (!mappedTo.containsKey(destId)) {
            mappedTo.put(destId, dest);
        }
    }

    public Object getMappedValue(Object src, Class<?> destType) {
        Map<Integer, Object> alreadyMappedValues = this.mappedFields.get(src);
        if (alreadyMappedValues != null) {
            for (Object alreadyMappedValue : alreadyMappedValues.values()) {
                if (alreadyMappedValue == null || !destType.isAssignableFrom(alreadyMappedValue.getClass())) continue;
                return alreadyMappedValue;
            }
        }
        return null;
    }
}

