/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.sharing.registry.db.utils.Committer;
import org.apache.airavata.sharing.registry.db.utils.DBConstants;
import org.apache.airavata.sharing.registry.db.utils.JPAUtils;
import org.apache.airavata.sharing.registry.db.utils.ObjectMapperSingleton;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T, E, Id> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);
    private Class<T> thriftGenericClass;
    private Class<E> dbEntityGenericClass;

    public AbstractRepository(Class<T> thriftGenericClass, Class<E> dbEntityGenericClass) {
        this.thriftGenericClass = thriftGenericClass;
        this.dbEntityGenericClass = dbEntityGenericClass;
    }

    public T create(T t) throws SharingRegistryException {
        return this.update(t);
    }

    public List<T> create(List<T> tList) throws SharingRegistryException {
        return this.update(tList);
    }

    public T update(T t) throws SharingRegistryException {
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        Object entity = mapper.map(t, this.dbEntityGenericClass);
        Object persistedCopy = this.execute(entityManager -> entityManager.merge(entity));
        return (T)mapper.map(persistedCopy, this.thriftGenericClass);
    }

    public List<T> update(List<T> tList) throws SharingRegistryException {
        ArrayList<T> returnList = new ArrayList<T>();
        for (T temp : tList) {
            returnList.add(this.update(temp));
        }
        return returnList;
    }

    public boolean delete(Id id) throws SharingRegistryException {
        this.execute(entityManager -> {
            Object entity = entityManager.find(this.dbEntityGenericClass, id);
            entityManager.remove(entity);
            return entity;
        });
        return true;
    }

    public boolean delete(List<Id> idList) throws SharingRegistryException {
        for (Id id : idList) {
            this.delete(id);
        }
        return true;
    }

    public T get(Id id) throws SharingRegistryException {
        Object entity = this.execute(entityManager -> entityManager.find(this.dbEntityGenericClass, id));
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        if (entity == null) {
            return null;
        }
        return (T)mapper.map(entity, this.thriftGenericClass);
    }

    public boolean isExists(Id id) throws SharingRegistryException {
        return this.get(id) != null;
    }

    public List<T> get(List<Id> idList) throws SharingRegistryException {
        ArrayList<T> returnList = new ArrayList<T>();
        for (Id id : idList) {
            returnList.add(this.get(id));
        }
        return returnList;
    }

    public List<T> select(Map<String, String> filters, int offset, int limit) throws SharingRegistryException {
        String query = "SELECT DISTINCT p from " + this.dbEntityGenericClass.getSimpleName() + " as p";
        ArrayList<String> parameters = new ArrayList<String>();
        int parameterCount = 1;
        if (filters != null && filters.size() != 0) {
            query = query + " WHERE ";
            for (String k : filters.keySet()) {
                query = query + "p." + k + " = ?" + parameterCount + " AND ";
                parameters.add(filters.get(k));
                ++parameterCount;
            }
            query = query.substring(0, query.length() - 5);
        }
        String queryString = query = query + " ORDER BY p.createdTime DESC";
        int newLimit = limit < 0 ? DBConstants.SELECT_MAX_ROWS : limit;
        List resultSet = this.execute(entityManager -> {
            Query q = entityManager.createQuery(queryString);
            for (int i = 0; i < parameters.size(); ++i) {
                q.setParameter(i + 1, parameters.get(i));
            }
            return q.setFirstResult(offset).setMaxResults(newLimit).getResultList();
        });
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList gatewayList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$4(gatewayList, (Mapper)mapper, arg_0));
        return gatewayList;
    }

    public List<T> select(String queryString, Map<String, Object> queryParameters, int offset, int limit) throws SharingRegistryException {
        int newLimit = limit < 0 ? DBConstants.SELECT_MAX_ROWS : limit;
        List resultSet = this.execute(entityManager -> {
            Query q = entityManager.createQuery(queryString);
            for (Map.Entry queryParam : queryParameters.entrySet()) {
                q.setParameter((String)queryParam.getKey(), queryParam.getValue());
            }
            return q.setFirstResult(offset).setMaxResults(newLimit).getResultList();
        });
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList gatewayList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$6(gatewayList, (Mapper)mapper, arg_0));
        return gatewayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(Committer<EntityManager, R> committer) throws SharingRegistryException {
        try (EntityManager entityManager = JPAUtils.getEntityManager();){
            entityManager.getTransaction().begin();
            R r = committer.commit(entityManager);
            entityManager.getTransaction().commit();
            R r2 = r;
            return r2;
        }
    }

    private /* synthetic */ void lambda$select$6(List gatewayList, Mapper mapper, Object rs) {
        gatewayList.add(mapper.map(rs, this.thriftGenericClass));
    }

    private /* synthetic */ void lambda$select$4(List gatewayList, Mapper mapper, Object rs) {
        gatewayList.add(mapper.map(rs, this.thriftGenericClass));
    }
}

