/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.io.UnrecoverableIOException;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    private static final Log log = LogFactory.getLog(RestUtils.class);
    public static final List<String> HTTP_HEADER_METADATA_NAMES = Arrays.asList("content-type", "content-md5", "content-length", "content-language", "expires", "cache-control", "content-disposition", "content-encoding");

    public static String encodeUrlString(String path) throws ServiceException {
        try {
            String encodedPath = URLEncoder.encode(path, Constants.DEFAULT_ENCODING);
            encodedPath = encodedPath.replaceAll("\\+", "%20");
            encodedPath = encodedPath.replaceAll("%40", "@");
            return encodedPath;
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServiceException("Unable to encode path: " + path, uee);
        }
    }

    public static String encodeUrlPath(String path, String delimiter) throws ServiceException {
        StringBuffer result = new StringBuffer();
        String[] tokens = path.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.append(RestUtils.encodeUrlString(tokens[i]));
            if (i >= tokens.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String makeS3CanonicalString(String method, String resource, Map<String, Object> headersMap, String expires) {
        return RestUtils.makeServiceCanonicalString(method, resource, headersMap, expires, "x-amz-");
    }

    public static String makeServiceCanonicalString(String method, String resource, Map<String, Object> headersMap, String expires, String headerPrefix) {
        Object value;
        String key;
        StringBuffer canonicalStringBuf = new StringBuffer();
        canonicalStringBuf.append(method + "\n");
        TreeMap<String, Object> interestingHeaders = new TreeMap<String, Object>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                String lk;
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(headerPrefix)) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, Object> entry : interestingHeaders.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith(headerPrefix)) {
                canonicalStringBuf.append(key).append(':').append(value);
            } else {
                canonicalStringBuf.append(value);
            }
            canonicalStringBuf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            canonicalStringBuf.append(resource);
        } else {
            canonicalStringBuf.append(resource.substring(0, queryIndex));
        }
        String[] stringArray = new String[]{"acl", "torrent", "logging", "location", "requestPayment", "versions", "versioning", "policy", "versionId"};
        boolean existingParams = false;
        for (String resourceParam : stringArray) {
            Pattern pattern = Pattern.compile(".*[&?]" + resourceParam + "(=.+)?($|&).*");
            Matcher matcher = pattern.matcher(resource);
            if (!matcher.matches()) continue;
            canonicalStringBuf.append((existingParams ? "&" : "?") + resourceParam);
            if (matcher.group(1) != null) {
                canonicalStringBuf.append(matcher.group(1));
            }
            existingParams = true;
        }
        return canonicalStringBuf.toString();
    }

    public static HttpClientAndConnectionManager initHttpConnection(final AWSRequestAuthorizer awsRequestAuthorizer, HostConfiguration hostConfig, Jets3tProperties jets3tProperties, String userAgentDescription, CredentialsProvider credentialsProvider) {
        HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
        connectionParams.setConnectionTimeout(jets3tProperties.getIntProperty("httpclient.connection-timeout-ms", 60000));
        connectionParams.setSoTimeout(jets3tProperties.getIntProperty("httpclient.socket-timeout-ms", 60000));
        connectionParams.setStaleCheckingEnabled(jets3tProperties.getBoolProperty("httpclient.stale-checking-enabled", true));
        int maxConnections = jets3tProperties.getIntProperty("httpclient.max-connections", 20);
        int maxConnectionsPerHost = jets3tProperties.getIntProperty("httpclient.max-connections-per-host", 0);
        if (maxConnectionsPerHost == 0) {
            maxConnectionsPerHost = maxConnections;
        }
        connectionParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, maxConnectionsPerHost);
        connectionParams.setMaxTotalConnections(maxConnections);
        if (jets3tProperties.containsKey("httpclient.socket-receive-buffer")) {
            connectionParams.setReceiveBufferSize(jets3tProperties.getIntProperty("httpclient.socket-receive-buffer", 0));
        }
        if (jets3tProperties.containsKey("httpclient.socket-send-buffer")) {
            connectionParams.setSendBufferSize(jets3tProperties.getIntProperty("httpclient.socket-send-buffer", 0));
        }
        connectionParams.setTcpNoDelay(true);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(connectionParams);
        HttpClientParams clientParams = new HttpClientParams();
        String userAgent = jets3tProperties.getStringProperty("httpclient.useragent", null);
        if (userAgent == null) {
            userAgent = ServiceUtils.getUserAgentDescription(userAgentDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting user agent string: " + userAgent));
        }
        clientParams.setParameter("http.useragent", (Object)userAgent);
        clientParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        clientParams.setBooleanParameter("http.protocol.expect-continue", true);
        final int retryMaxCount = jets3tProperties.getIntProperty("httpclient.retry-max", 5);
        clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryMaxCount, false){

            public boolean retryMethod(HttpMethod httpMethod, IOException ioe, int executionCount) {
                if (super.retryMethod(httpMethod, ioe, executionCount)) {
                    block6: {
                        if (ioe instanceof UnrecoverableIOException) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Deliberate interruption, will not retry");
                            }
                            return false;
                        }
                        httpMethod.releaseConnection();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Retrying " + httpMethod.getName() + " request with path '" + httpMethod.getPath() + "' - attempt " + executionCount + " of " + retryMaxCount));
                        }
                        try {
                            awsRequestAuthorizer.authorizeHttpRequest(httpMethod);
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block6;
                            log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        long connectionManagerTimeout = jets3tProperties.getLongProperty("httpclient.connection-manager-timeout", 0L);
        clientParams.setConnectionManagerTimeout(connectionManagerTimeout);
        HttpClient httpClient = new HttpClient(clientParams, (HttpConnectionManager)connectionManager);
        httpClient.setHostConfiguration(hostConfig);
        if (credentialsProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using credentials provider class: " + credentialsProvider.getClass().getName()));
            }
            httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)credentialsProvider);
            if (jets3tProperties.getBoolProperty("httpclient.authentication-preemptive", false)) {
                httpClient.getParams().setAuthenticationPreemptive(true);
            }
        }
        return new HttpClientAndConnectionManager(httpClient, (HttpConnectionManager)connectionManager);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String endpoint) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null, endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, String proxyHostAddress, int proxyPort, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        String s3Endpoint = jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        RestUtils.initHttpProxy(httpClient, jets3tProperties, proxyAutodetect, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, s3Endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String endpoint) {
        block11: {
            HostConfiguration hostConfig = httpClient.getHostConfiguration();
            if (proxyHostAddress != null && proxyPort != -1) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using Proxy: " + proxyHostAddress + ":" + proxyPort));
                }
                hostConfig.setProxy(proxyHostAddress, proxyPort);
                if (proxyUser != null && !proxyUser.trim().equals("")) {
                    if (proxyDomain != null) {
                        httpClient.getState().setProxyCredentials(new AuthScope(proxyHostAddress, proxyPort), (Credentials)new NTCredentials(proxyUser, proxyPassword, proxyHostAddress, proxyDomain));
                    } else {
                        httpClient.getState().setProxyCredentials(new AuthScope(proxyHostAddress, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                    }
                }
            } else if (proxyAutodetect) {
                ProxyHost proxyHost = null;
                try {
                    proxyHost = PluginProxyUtil.detectProxy(new URL("http://" + endpoint));
                    if (proxyHost != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Using Proxy: " + proxyHost.getHostName() + ":" + proxyHost.getPort()));
                        }
                        hostConfig.setProxyHost(proxyHost);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)"Unable to set proxy configuration", t);
                }
            }
        }
    }

    public static long getAWSTimeAdjustment() throws Exception {
        RestS3Service restService = new RestS3Service(null);
        HttpClient client = restService.getHttpClient();
        long timeOffset = 0L;
        GetMethod getMethod = new GetMethod("http://aws.amazon.com/");
        int result = client.executeMethod((HttpMethod)getMethod);
        if (result == 200) {
            Header dateHeader = getMethod.getResponseHeader("Date");
            Date awsTime = ServiceUtils.parseRfc822Date(dateHeader.getValue());
            Date localTime = new Date();
            timeOffset = awsTime.getTime() - localTime.getTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculated time offset value of " + timeOffset + " milliseconds between the local machine and an AWS server"));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Unable to calculate value of time offset between the local machine and AWS server");
        }
        return timeOffset;
    }

    public static Map<String, String> convertHeadersToMap(Header[] headers) {
        HashMap<String, String> s3Headers = new HashMap<String, String>();
        for (Header header : headers) {
            s3Headers.put(header.getName(), header.getValue());
        }
        return s3Headers;
    }
}

