/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.util;

import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

public class PrivateKeyStore {
    private Map<String, PrivateKey> privateKeyMap = new HashMap<String, PrivateKey>();
    private static PrivateKeyStore privateKeyStore = null;

    private PrivateKeyStore() {
    }

    public static PrivateKeyStore getPrivateKeyStore() {
        if (privateKeyStore == null) {
            privateKeyStore = new PrivateKeyStore();
        }
        return privateKeyStore;
    }

    public synchronized void addKey(String tokenId, PrivateKey privateKey) {
        this.privateKeyMap.put(tokenId, privateKey);
    }

    public synchronized PrivateKey getKey(String tokenId) {
        PrivateKey privateKey = this.privateKeyMap.get(tokenId);
        if (privateKey != null) {
            this.privateKeyMap.remove(tokenId);
        }
        return privateKey;
    }
}

