/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.core.transports.CarbonServlet;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;

public class HTTPGetProcessorListener
implements ServiceListener {
    CarbonServlet carbonServlet;
    BundleContext bundleContext;

    public HTTPGetProcessorListener(CarbonServlet carbonServlet, BundleContext bundleContext) {
        this.carbonServlet = carbonServlet;
        this.bundleContext = bundleContext;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference reference = serviceEvent.getServiceReference();
        this.addHTTPGetRequestProcessor(reference, serviceEvent.getType());
    }

    public void addHTTPGetRequestProcessor(ServiceReference reference, int action) {
        HttpGetRequestProcessor getRequestProcessor = (HttpGetRequestProcessor)this.bundleContext.getService(reference);
        String item = (String)reference.getProperty("item");
        if (action == 1 || action == 2) {
            this.carbonServlet.addGetRequestProcessor(item, getRequestProcessor);
        } else if (action == 4) {
            this.carbonServlet.removeGetRequestProcessor(item);
        }
    }
}

