/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.multitenancy.TenantAxisConfigurator;
import org.wso2.carbon.core.persistence.AbstractPersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.util.ParameterUtil;

public class ModulePersistenceManager
extends AbstractPersistenceManager {
    private static final Log log = LogFactory.getLog(ModulePersistenceManager.class);

    public ModulePersistenceManager(AxisConfiguration axisConfig, PersistenceFactory pf) throws AxisFault {
        super(axisConfig, pf.getModuleFilePM(), pf);
    }

    public ModulePersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            if (this.pf == null) {
                this.pf = PersistenceFactory.getInstance(axisConfig);
            }
            this.fpm = this.pf.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error getting PersistenceFactory instance", (Throwable)e);
        }
    }

    public OMElement getModule(String moduleName, String moduleVersion) throws Exception {
        try {
            if (this.getCurrentFPM().fileExists(moduleName)) {
                String moduleXPath = "/version" + PersistenceUtils.getXPathAttrPredicate("id", moduleVersion);
                OMElement sgElement = (OMElement)this.getCurrentFPM().get(moduleName, moduleXPath);
                if (this.getModuleFilePM().getAttribute(moduleName, moduleXPath + "/@" + "successfullyAdded") != null) {
                    return sgElement;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully retrieved " + moduleName + " module resource"));
            }
        }
        catch (Throwable e) {
            this.handleException("Could not get the Module resource", e);
        }
        return null;
    }

    public void globallyEngageModule(AxisModule module) throws Exception {
        try {
            this.handleGlobalModule(module, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)(module.getName() + " is globally engaged"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to engage " + module.getName() + " globally", e);
        }
    }

    public void globallyDisengageModule(AxisModule module) throws Exception {
        try {
            this.handleGlobalModule(module, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)(module.getName() + " is globally disengaged"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to disengage " + module.getName() + " globally", e);
        }
    }

    public void handleNewModuleAddition(AxisModule axisModule, String moduleName, String moduleVersion) throws Exception {
        try {
            this.getModuleFilePM().beginTransaction(moduleName);
            this.getModuleFilePM().put(moduleName, this.omFactory.createOMAttribute("name", null, moduleName), "/");
            OMElement module = this.omFactory.createOMElement("version", null);
            module.addAttribute("id", moduleVersion, null);
            AxisConfigurator configurator = this.axisConfig.getConfigurator();
            boolean isGloballyEngaged = false;
            if (configurator instanceof CarbonAxisConfigurator) {
                isGloballyEngaged = ((CarbonAxisConfigurator)configurator).isGlobalyEngaged(axisModule);
            } else if (configurator instanceof TenantAxisConfigurator) {
                isGloballyEngaged = ((TenantAxisConfigurator)configurator).isGlobalyEngaged(axisModule);
            }
            module.addAttribute("globallyEngaged", String.valueOf(isGloballyEngaged), null);
            this.getModuleFilePM().put(moduleName, module, "/");
            String xpathOfCurrentModuleVersion = "/version" + PersistenceUtils.getXPathAttrPredicate("id", moduleVersion);
            String policiesXpath = PersistenceUtils.getResourcePath(axisModule) + "/" + "policies";
            this.writeParameters(moduleName, axisModule.getParameters(), xpathOfCurrentModuleVersion);
            List<Policy> modulePolicies = this.getModulePolicies(axisModule);
            if (modulePolicies != null && modulePolicies.size() > 0 && !this.getModuleFilePM().elementExists(moduleName, policiesXpath)) {
                OMElement policiesEl = this.omFactory.createOMElement("policies", null);
                this.getModuleFilePM().put(moduleName, policiesEl, xpathOfCurrentModuleVersion);
            }
            for (Policy modulePolicy : modulePolicies) {
                if (modulePolicy.getId() == null) {
                    modulePolicy.setId(UUIDGenerator.getUUID());
                }
                OMElement policyElement = PersistenceUtils.createPolicyElement(modulePolicy);
                OMElement policyWrapperElement = this.omFactory.createOMElement("policy", null);
                OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
                idElement.setText("" + modulePolicy.getId());
                policyWrapperElement.addChild((OMNode)idElement);
                policyWrapperElement.addAttribute("policyType", "" + modulePolicy.getType(), null);
                policyWrapperElement.addAttribute("version", moduleVersion, null);
                policyWrapperElement.addChild((OMNode)policyElement);
                this.getModuleFilePM().put(moduleName, policyWrapperElement, policiesXpath);
            }
            module.addAttribute("successfullyAdded", "true", null);
            this.getModuleFilePM().commitTransaction(moduleName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new module - " + axisModule.getName() + "- version " + moduleVersion));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(moduleName, "Unable to handle new module addition. Module: " + Utils.getModuleName((String)moduleName, (String)moduleVersion), e);
            PersistenceUtils.markFaultyModule(axisModule);
        }
    }

    public void handleExistingModuleInit(OMElement moduleResource, AxisModule axisModule) throws Exception {
        String moduleName = axisModule.getName();
        String version = PersistenceUtils.getModuleVersion(axisModule);
        try {
            this.getModuleFilePM().beginTransaction(moduleName);
            if (this.getModuleFilePM().fileExists(moduleName)) {
                String xpathString = PersistenceUtils.getResourcePath(axisModule) + "/" + "parameter";
                AXIOMXPath xpathExpression = new AXIOMXPath(xpathString);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handling existing module " + moduleName + version + "evaluating xpath " + xpathExpression));
                }
                List matchedNodes = xpathExpression.selectNodes((Object)moduleResource);
                for (Object node : matchedNodes) {
                    OMElement paramEl = (OMElement)node;
                    Parameter parameter = ParameterUtil.createParameter(paramEl);
                    Parameter p = axisModule.getParameter(paramEl.getAttributeValue(new QName("name")));
                    if (p != null && p.isLocked()) continue;
                    axisModule.addParameter(parameter);
                }
            }
            axisModule.getPolicySubject().clear();
            String policiesXpath = PersistenceUtils.getResourcePath(axisModule) + "/" + "policies" + "/" + "policy";
            if (this.getModuleFilePM().elementExists(moduleName, policiesXpath)) {
                AXIOMXPath xpathExpr = new AXIOMXPath(policiesXpath);
                List policyElements = xpathExpr.selectNodes((Object)moduleResource);
                for (Object node : policyElements) {
                    OMElement policyElement = (OMElement)node;
                    Policy policy = PolicyEngine.getPolicy((OMElement)policyElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy")));
                    axisModule.getPolicySubject().attachPolicy(policy);
                }
            }
            PersistenceUtils.handleGlobalParams(axisModule, moduleResource);
            this.getModuleFilePM().commitTransaction(moduleName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized module - " + Utils.getModuleName((String)axisModule.getName(), (String)version)));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(moduleName, "Unable to handle module init. Module: " + Utils.getModuleName((String)axisModule.getName(), (String)version), e);
            PersistenceUtils.markFaultyModule(axisModule);
        }
    }

    public void removeModuleParameter(AxisModule module, Parameter parameter) throws Exception {
        String version = PersistenceUtils.getModuleVersion(module);
        this.removeParameter(module.getName(), parameter.getName(), "/version" + PersistenceUtils.getXPathAttrPredicate("id", version));
    }

    public void updateModuleParameter(AxisModule module, Parameter parameter) throws Exception {
        try {
            String version = PersistenceUtils.getModuleVersion(module);
            String xpath = "/version" + PersistenceUtils.getXPathAttrPredicate("id", version);
            this.updateParameter(module.getName(), parameter, xpath);
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to update module parameter " + parameter.getName() + " of module " + module.getName(), e);
        }
    }

    public void removeModule(AxisModule module) throws Exception {
        String version = PersistenceUtils.getModuleVersion(module);
        this.removeResource(module.getName(), "/version" + PersistenceUtils.getXPathAttrPredicate("id", version));
    }

    private List<Policy> getModulePolicies(AxisModule axisModule) throws Exception {
        ArrayList<Policy> modulePolicies = new ArrayList<Policy>();
        PolicySubject modulePolicySubject = axisModule.getPolicySubject();
        ArrayList policyList = new ArrayList(modulePolicySubject.getAttachedPolicyComponents());
        Policy policy = null;
        for (PolicyComponent policyElement : policyList) {
            PolicyComponent attachedPolicyComponent;
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : policy.merge((Policy)policyElement);
                continue;
            }
            PolicyReference policyReference = (PolicyReference)policyElement;
            String key = policyReference.getURI();
            int pos = key.indexOf(35);
            if (pos == 0) {
                key = key.substring(1);
            } else if (pos > 0) {
                key = key.substring(0, pos);
            }
            if (!((attachedPolicyComponent = modulePolicySubject.getAttachedPolicyComponent(key)) instanceof Policy)) continue;
            policy = (Policy)attachedPolicyComponent;
        }
        if (policy != null) {
            modulePolicies.add(policy);
        }
        return modulePolicies;
    }

    private void handleGlobalModule(AxisModule module, boolean engage) throws Exception {
        this.getCurrentFPM().beginTransaction(module.getName());
        if (this.getCurrentFPM().elementExists(module.getName(), PersistenceUtils.getResourcePath(module))) {
            OMElement moduleElement = this.getModule(module.getName(), PersistenceUtils.getModuleVersion(module));
            moduleElement.addAttribute("globallyEngaged", String.valueOf(engage), null);
            this.getModuleFilePM().setMetaFileModification(module.getName());
        } else {
            this.handleException("Trying to engage or disengage unavailable module " + module.getName());
        }
        this.getCurrentFPM().commitTransaction(module.getName());
    }

    public void persistModulePolicy(String moduleName, String moduleVersion, Policy policy, String policyUuid, String policyType, String modulePath) throws Exception {
        boolean transactionStarted = this.getModuleFilePM().isTransactionStarted(moduleName);
        if (!transactionStarted) {
            this.getModuleFilePM().beginTransaction(moduleName);
        }
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
        policyWrapperElement.addAttribute("policyType", policyType, null);
        OMElement idElement = omFactory.createOMElement("policyUUID", null);
        idElement.setText("" + policyUuid);
        policyWrapperElement.addChild((OMNode)idElement);
        policyWrapperElement.addAttribute("version", moduleVersion, null);
        OMElement policyElementToPersist = PersistenceUtils.createPolicyElement(policy);
        policyWrapperElement.addChild((OMNode)policyElementToPersist);
        if (!this.getModuleFilePM().elementExists(moduleName, modulePath + "/" + "policies")) {
            this.getModuleFilePM().put(moduleName, omFactory.createOMElement("policies", null), modulePath);
        } else {
            String pathToPolicy = modulePath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate("policyUUID", policyUuid);
            if (this.getModuleFilePM().elementExists(moduleName, pathToPolicy)) {
                this.getModuleFilePM().delete(moduleName, pathToPolicy);
            }
        }
        this.getModuleFilePM().put(moduleName, policyWrapperElement, modulePath + "/" + "policies");
        if (!transactionStarted) {
            this.getModuleFilePM().commitTransaction(moduleName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Policy is saved in the file system for " + moduleName));
        }
    }
}

