/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.transports.TransportBuilderUtils;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.core.transports.util.TransportParameter;

public abstract class AbstractTransportService
implements TransportService {
    protected String transportName;
    private static final Log log = LogFactory.getLog(AbstractTransportService.class);

    public AbstractTransportService(String transportName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing " + transportName + " transport service"));
        }
        this.transportName = transportName;
    }

    @Override
    public TransportParameter[] getGlobalTransportParameters(boolean listener, AxisConfiguration axisConfig) throws Exception {
        TransportInDescription transport;
        TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
        if (listener) {
            transport = axisConfig.getTransportIn(this.transportName);
            if (transport == null) {
                transport = transportPM.getTransportListener(this.transportName, false);
            }
        } else {
            transport = axisConfig.getTransportOut(this.transportName);
            if (transport == null) {
                transport = transportPM.getTransportSender(this.transportName, false);
            }
        }
        return this.getParameters((ParameterInclude)transport);
    }

    @Override
    public String getName() {
        return this.transportName;
    }

    @Override
    public TransportParameter[] getServiceLevelTransportParameters(String service, boolean listener, AxisConfiguration axisConfig) throws Exception {
        if (axisConfig.getService(service) == null) {
            throw new CarbonException("No service exists by the name : " + service);
        }
        return this.getGlobalTransportParameters(listener, axisConfig);
    }

    @Override
    public boolean isAvailable(boolean listener, AxisConfiguration axisConfig) {
        try {
            TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
            return transportPM.getTransportElement(this.transportName, listener) != null;
        }
        catch (Exception e) {
            log.error((Object)"Error while checking the transport availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEnabled(boolean listener, AxisConfiguration axisConfig) {
        if (listener) {
            return axisConfig.getTransportIn(this.transportName) != null;
        }
        return axisConfig.getTransportOut(this.transportName) != null;
    }

    @Override
    public void updateGlobalTransportParameters(TransportParameter[] params, boolean listener, ConfigurationContext cfgCtx) throws Exception {
        AxisConfiguration axisConfig = cfgCtx.getAxisConfiguration();
        TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
        if (listener) {
            TransportInDescription transportIn = axisConfig.getTransportIn(this.transportName);
            if (transportIn != null) {
                transportIn.getReceiver().stop();
            } else {
                transportIn = transportPM.getTransportListener(this.transportName, true);
                axisConfig.addTransportIn(transportIn);
            }
            this.setParameters((ParameterInclude)transportIn, params);
            try {
                transportIn.getReceiver().init(cfgCtx, transportIn);
                transportIn.getReceiver().start();
            }
            catch (Throwable t) {
                axisConfig.getTransportsIn().remove(this.transportName);
                String msg = "Error while initializing the " + this.transportName + " listener";
                log.error((Object)msg, t);
                throw new AxisFault(msg, t);
            }
            transportPM.saveTransportListener(transportIn, true);
        } else {
            TransportOutDescription transportOut = axisConfig.getTransportOut(this.transportName);
            if (transportOut != null) {
                transportOut.getSender().stop();
            } else {
                transportOut = transportPM.getTransportSender(this.transportName, true);
                axisConfig.addTransportOut(transportOut);
            }
            this.setParameters((ParameterInclude)transportOut, params);
            try {
                transportOut.getSender().init(cfgCtx, transportOut);
            }
            catch (Throwable t) {
                axisConfig.getTransportsOut().remove(this.transportName);
                String msg = "Error while initializing the " + this.transportName + " sender";
                log.error((Object)msg, t);
                throw new AxisFault(msg, t);
            }
            transportPM.saveTransportSender(transportOut, true);
        }
    }

    @Override
    public void updateServiceLevelTransportParameters(String service, TransportParameter[] params, boolean listener, ConfigurationContext cfgCtx) throws Exception {
        AxisConfiguration axisConfig = cfgCtx.getAxisConfiguration();
        if (axisConfig.getService(service) == null) {
            throw new CarbonException("No service exists by the name : " + service);
        }
        this.updateGlobalTransportParameters(params, listener, cfgCtx);
    }

    @Override
    public void disableTransport(boolean listener, AxisConfiguration axisConfig) throws Exception {
        TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
        if (listener) {
            TransportInDescription transport = axisConfig.getTransportIn(this.transportName);
            if (transport != null) {
                transport.getReceiver().stop();
                axisConfig.getTransportsIn().remove(this.transportName);
            } else {
                log.warn((Object)(this.transportName + " listener is already disabled"));
            }
        } else {
            TransportOutDescription transport = axisConfig.getTransportOut(this.transportName);
            if (transport != null) {
                transport.getSender().stop();
                axisConfig.getTransportsOut().remove(this.transportName);
            } else {
                log.warn((Object)(this.transportName + " sender is already disabled"));
            }
        }
        transportPM.setTransportEnabled(this.transportName, listener, false);
    }

    @Override
    public void addTransportParameter(TransportParameter param, boolean listener, ConfigurationContext cfgCtx) throws Exception {
        AxisConfiguration axisConfig = cfgCtx.getAxisConfiguration();
        TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
        Object transport = listener ? axisConfig.getTransportIn(this.transportName) : axisConfig.getTransportOut(this.transportName);
        if (transport == null) {
            transportPM.addParameter(this.transportName, listener, false, TransportBuilderUtils.toAxisParameter(param));
        } else {
            TransportParameter[] newParams;
            TransportParameter[] params = this.getGlobalTransportParameters(listener, axisConfig);
            if (params == null) {
                newParams = new TransportParameter[]{param};
            } else {
                boolean overwritten = false;
                for (int i = 0; i < params.length; ++i) {
                    if (!params[i].getName().equals(param.getName())) continue;
                    params[i] = param;
                    overwritten = true;
                    break;
                }
                if (overwritten) {
                    newParams = params;
                } else {
                    newParams = new TransportParameter[params.length + 1];
                    System.arraycopy(params, 0, newParams, 0, params.length);
                    newParams[newParams.length - 1] = param;
                }
            }
            this.updateGlobalTransportParameters(newParams, listener, cfgCtx);
        }
    }

    @Override
    public void removeTransportParameter(String param, boolean listener, ConfigurationContext cfgCtx) throws Exception {
        AxisConfiguration axisConfig = cfgCtx.getAxisConfiguration();
        TransportPersistenceManager transportPM = new TransportPersistenceManager(axisConfig);
        Object transport = listener ? axisConfig.getTransportIn(this.transportName) : axisConfig.getTransportOut(this.transportName);
        if (transport != null) {
            TransportParameter[] params = this.getGlobalTransportParameters(listener, axisConfig);
            if (params != null) {
                ArrayList<TransportParameter> newParams = new ArrayList<TransportParameter>();
                boolean paramFound = false;
                for (TransportParameter p : params) {
                    if (p.getName().equals(param)) {
                        paramFound = true;
                        continue;
                    }
                    newParams.add(p);
                }
                if (paramFound) {
                    this.updateGlobalTransportParameters(newParams.toArray(new TransportParameter[newParams.size()]), listener, cfgCtx);
                    return;
                }
            }
            throw new CarbonException("The transport parameter : " + param + " does not exist");
        }
        transportPM.removeParameter(this.transportName, listener, false, param);
    }

    @Override
    public abstract boolean dependenciesAvailable(TransportParameter[] var1);

    private void setParameters(ParameterInclude transport, TransportParameter[] params) throws Exception {
        transport.getParameters().clear();
        if (params != null) {
            for (TransportParameter p : params) {
                transport.addParameter(TransportBuilderUtils.toAxisParameter(p));
            }
        }
    }

    private TransportParameter[] getParameters(ParameterInclude transport) {
        if (transport == null || transport.getParameters() == null || transport.getParameters().size() == 0) {
            return null;
        }
        ArrayList<TransportParameter> params = new ArrayList<TransportParameter>();
        ArrayList axisParams = transport.getParameters();
        for (Parameter p : axisParams) {
            TransportParameter transportParam = new TransportParameter();
            transportParam.setName(p.getName());
            transportParam.setValue(p.getValue().toString());
            transportParam.setParamElement(p.getParameterElement().toString());
            params.add(transportParam);
        }
        return params.toArray(new TransportParameter[params.size()]);
    }
}

