/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bootstrap;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;

public class Bootstrap {
    private final Set<URL> classpath = new LinkedHashSet<URL>();
    private static final String CARBON_HOME = "carbon.home";
    protected static final String ROOT = System.getProperty("carbon.home", ".");

    public static void main(String[] args) {
        new Bootstrap().loadClass(args);
    }

    protected final void loadClass(String[] args) {
        try {
            this.addClassPathEntries();
            URLClassLoader cl = new URLClassLoader(this.classpath.toArray(new URL[this.classpath.size()]));
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> appClass = cl.loadClass(this.getClassToLoad());
            Object app = appClass.newInstance();
            Method m = app.getClass().getMethod(this.getMethodToInvoke(), String[].class);
            m.invoke(app, new Object[]{args});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    protected void addClassPathEntries() throws MalformedURLException {
        this.addFileUrl(new File(ROOT + File.separator + "lib" + File.separator));
        this.addJarFileUrls(new File(ROOT + File.separator + "lib"));
    }

    protected final void addFileUrl(File file) throws MalformedURLException {
        this.classpath.add(file.toURI().toURL());
    }

    protected final void addJarFileUrls(File root) throws MalformedURLException {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar")) continue;
            this.classpath.add(child.toURI().toURL());
        }
    }

    protected String getClassToLoad() {
        return "org.wso2.carbon.server.Main";
    }

    protected String getMethodToInvoke() {
        return "main";
    }
}

