/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.wso2.carbon.registry.core.BasicFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.InMemoryEmbeddedRegistry;

@Deprecated
public abstract class RegistryFactory {
    public static final String PROPFILE_PROPERTY = "registry.propFile";
    public static final String FACTORY_CLASS_PROPERTY = "registry.factoryClass";
    public static final String REG_CLASS_PROPERTY = "registry.class";
    public static final String PROPERTY_FILE_NAME = "registry.properties";

    public static RegistryFactory newInstance() throws RegistryException {
        String propertyFileName = System.getProperty(PROPFILE_PROPERTY);
        return RegistryFactory.newInstance(propertyFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistryFactory newInstance(String propertyFileName) throws RegistryException {
        if (propertyFileName == null) {
            propertyFileName = PROPERTY_FILE_NAME;
        }
        Properties properties = new Properties();
        File props = new File(propertyFileName);
        if (props.exists()) {
            try {
                FileInputStream fileIn = null;
                try {
                    fileIn = new FileInputStream(props);
                    properties.load(fileIn);
                }
                finally {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RegistryException("Couldn't load properties file '" + propertyFileName + "'");
            }
        }
        return RegistryFactory.newInstance(properties);
    }

    public static RegistryFactory newInstance(Properties properties) throws RegistryException {
        Class regClass = InMemoryEmbeddedRegistry.class;
        if (properties != null) {
            String factoryClassname = properties.getProperty(FACTORY_CLASS_PROPERTY);
            if (factoryClassname != null) {
                Class<?> factoryClass;
                try {
                    factoryClass = Class.forName(factoryClassname);
                }
                catch (ClassNotFoundException e) {
                    throw new RegistryException("Couldn't load factory class " + factoryClassname, e);
                }
                try {
                    Constructor<?> c = factoryClass.getConstructor(Properties.class);
                    try {
                        return (RegistryFactory)c.newInstance(properties);
                    }
                    catch (Exception e) {
                        throw new RegistryException("Couldn't create factory of type " + factoryClassname, e);
                    }
                }
                catch (NoSuchMethodException e) {
                    try {
                        return (RegistryFactory)factoryClass.newInstance();
                    }
                    catch (Exception e1) {
                        throw new RegistryException("Couldn't create factory of type " + factoryClassname, e);
                    }
                }
            }
            String registryClassname = properties.getProperty(REG_CLASS_PROPERTY);
            if (registryClassname != null) {
                try {
                    regClass = Class.forName(registryClassname);
                }
                catch (ClassNotFoundException e) {
                    throw new RegistryException("Couldn't load Registry class " + registryClassname, e);
                }
            }
        }
        return new BasicFactory(regClass);
    }

    public abstract Registry getRegistry() throws RegistryException;

    public abstract Registry getRegistry(String var1, String var2) throws RegistryException;
}

