/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.util;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorUtils {
    private static final Logger log = LoggerFactory.getLogger(OrchestratorUtils.class);

    public static void updageAndPublishExperimentStatus(String experimentId, ExperimentStatus status, Publisher publisher, String gatewayId) {
        try {
            RegistryFactory.getDefaultExpCatalog().update(ExperimentCatalogModelType.EXPERIMENT_STATUS, (Object)status, (Object)experimentId);
            ExperimentStatusChangeEvent event = new ExperimentStatusChangeEvent(status.getState(), experimentId, gatewayId);
            String messageId = AiravataUtils.getId((String)"EXPERIMENT");
            MessageContext messageContext = new MessageContext((TBase)event, MessageType.EXPERIMENT, messageId, gatewayId);
            messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            publisher.publish(messageContext);
        }
        catch (RegistryException e) {
            log.error("expId : " + experimentId + " Error while updating experiment status to " + status.toString(), (Throwable)e);
        }
        catch (AiravataException e) {
            log.error("expId : " + experimentId + " Error while publishing experiment status to " + status.toString(), (Throwable)e);
        }
    }

    public static ExperimentStatus getExperimentStatus(String experimentId) throws RegistryException {
        return (ExperimentStatus)RegistryFactory.getDefaultExpCatalog().get(ExperimentCatalogModelType.EXPERIMENT_STATUS, (Object)experimentId);
    }
}

