/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.util.HashMap;
import org.globus.common.CoGProperties;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceCertStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;

public class Stores {
    private static String defaultCAFilesPattern = "*.0";
    private static String defaultCRLFilesPattern = "*.r*";
    private static String defaultSigningPolicyFilesPattern = "*.signing_policy";
    private static final HashMap<String, ReloadableTrustStore> TRUST_STORES = new HashMap();
    private static final HashMap<String, ReloadableCrlStore> CRL_STORES = new HashMap();
    private static final HashMap<String, ReloadableCaCertStore> CA_CERT_STORES = new HashMap();
    private static final HashMap<String, ResourceSigningPolicyStore> SIGNING_POLICY_STORES = new HashMap();
    private static final long CACHE_TIME_MILLIS = 3600000L;

    public static KeyStore getDefaultTrustStore() throws GeneralSecurityException, IOException {
        String pattern = "file:" + CoGProperties.getDefault().getCaCertLocations() + "/" + defaultCAFilesPattern;
        return Stores.getTrustStore(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getTrustStore(String casLocationPattern) throws GeneralSecurityException, IOException {
        HashMap<String, ReloadableTrustStore> hashMap = TRUST_STORES;
        synchronized (hashMap) {
            ReloadableTrustStore reloadableKeystore = TRUST_STORES.get(casLocationPattern);
            if (reloadableKeystore != null) {
                return reloadableKeystore.getTrustStore();
            }
            reloadableKeystore = new ReloadableTrustStore(casLocationPattern);
            TRUST_STORES.put(casLocationPattern, reloadableKeystore);
            return reloadableKeystore.getTrustStore();
        }
    }

    public static CertStore getDefaultCACertStore() throws GeneralSecurityException, NoSuchAlgorithmException {
        String pattern = "file:" + CoGProperties.getDefault().getCaCertLocations() + "/" + defaultCAFilesPattern;
        return Stores.getCACertStore(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertStore getCACertStore(String casLocationPattern) throws GeneralSecurityException, NoSuchAlgorithmException {
        HashMap<String, ReloadableCaCertStore> hashMap = CA_CERT_STORES;
        synchronized (hashMap) {
            ReloadableCaCertStore reloadableCaCertStore = CA_CERT_STORES.get(casLocationPattern);
            if (reloadableCaCertStore == null) {
                reloadableCaCertStore = new ReloadableCaCertStore(casLocationPattern);
                CA_CERT_STORES.put(casLocationPattern, reloadableCaCertStore);
            }
            return reloadableCaCertStore.getCaCertStore();
        }
    }

    public static CertStore getDefaultCRLStore() throws GeneralSecurityException, NoSuchAlgorithmException {
        String pattern = "file:" + CoGProperties.getDefault().getCaCertLocations() + "/" + defaultCRLFilesPattern;
        return Stores.getCRLStore(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertStore getCRLStore(String crlsLocationPattern) throws GeneralSecurityException, NoSuchAlgorithmException {
        HashMap<String, ReloadableCrlStore> hashMap = CRL_STORES;
        synchronized (hashMap) {
            ReloadableCrlStore reloadableCrlStore = CRL_STORES.get(crlsLocationPattern);
            if (reloadableCrlStore == null) {
                reloadableCrlStore = new ReloadableCrlStore(crlsLocationPattern);
                CRL_STORES.put(crlsLocationPattern, reloadableCrlStore);
            }
            return reloadableCrlStore.getCrlStore();
        }
    }

    public static ResourceSigningPolicyStore getDefaultSigningPolicyStore() throws GeneralSecurityException {
        String pattern = "file:" + CoGProperties.getDefault().getCaCertLocations() + "/" + defaultSigningPolicyFilesPattern;
        return Stores.getSigningPolicyStore(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceSigningPolicyStore getSigningPolicyStore(String signingPolicyLocationPattern) throws GeneralSecurityException {
        HashMap<String, ResourceSigningPolicyStore> hashMap = SIGNING_POLICY_STORES;
        synchronized (hashMap) {
            ResourceSigningPolicyStore signingPolicyStore = SIGNING_POLICY_STORES.get(signingPolicyLocationPattern);
            if (signingPolicyStore == null) {
                signingPolicyStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(signingPolicyLocationPattern));
                SIGNING_POLICY_STORES.put(signingPolicyLocationPattern, signingPolicyStore);
            }
            return signingPolicyStore;
        }
    }

    public static String getDefaultCAFilesPattern() {
        return defaultCAFilesPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCAFilesPattern(String defaultCAFilesPattern) {
        HashMap<String, ReloadableTrustStore> hashMap = TRUST_STORES;
        synchronized (hashMap) {
            HashMap<String, ReloadableCaCertStore> hashMap2 = CA_CERT_STORES;
            synchronized (hashMap2) {
                if (defaultCAFilesPattern == null || Stores.defaultCAFilesPattern.equals(defaultCAFilesPattern)) {
                    return;
                }
                Stores.defaultCAFilesPattern = defaultCAFilesPattern;
                TRUST_STORES.clear();
                CA_CERT_STORES.clear();
            }
        }
    }

    public static String getDefaultCRLFilesPattern() {
        return defaultCRLFilesPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCRLFilesPattern(String defaultCRLFilesPattern) {
        HashMap<String, ReloadableCrlStore> hashMap = CRL_STORES;
        synchronized (hashMap) {
            if (defaultCRLFilesPattern == null || Stores.defaultCRLFilesPattern.equals(defaultCRLFilesPattern)) {
                return;
            }
            Stores.defaultCRLFilesPattern = defaultCRLFilesPattern;
            CRL_STORES.clear();
        }
    }

    public static String getDefaultSigningPolicyFilesPattern() {
        return defaultSigningPolicyFilesPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSigningPolicyFilesPattern(String defaultSigningPolicyFilesPattern) {
        HashMap<String, ResourceSigningPolicyStore> hashMap = SIGNING_POLICY_STORES;
        synchronized (hashMap) {
            if (defaultSigningPolicyFilesPattern == null || Stores.defaultSigningPolicyFilesPattern.equals(defaultSigningPolicyFilesPattern)) {
                return;
            }
            Stores.defaultSigningPolicyFilesPattern = defaultSigningPolicyFilesPattern;
            SIGNING_POLICY_STORES.clear();
        }
    }

    private static class ReloadableCaCertStore {
        private final String casLocationPattern;
        private CertStore certStore;
        private long lastUpdateTime;

        protected ReloadableCaCertStore(String casLocationPattern) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            this.casLocationPattern = casLocationPattern;
            this.load();
        }

        private void load() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            this.certStore = CertStore.getInstance("PEMFilebasedCertStore", new ResourceCertStoreParameters(this.casLocationPattern, null));
            this.lastUpdateTime = System.currentTimeMillis();
        }

        protected boolean isStillValid() {
            return this.lastUpdateTime + 3600000L > System.currentTimeMillis();
        }

        protected CertStore getCaCertStore() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            if (!this.isStillValid()) {
                this.load();
            }
            return this.certStore;
        }
    }

    private static class ReloadableCrlStore {
        private final String crlsLocationPattern;
        private CertStore certStore;
        private long lastUpdateTime;

        protected ReloadableCrlStore(String crlsLocationPattern) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            this.crlsLocationPattern = crlsLocationPattern;
            this.load();
        }

        private void load() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            this.certStore = CertStore.getInstance("PEMFilebasedCertStore", new ResourceCertStoreParameters(null, this.crlsLocationPattern));
            this.lastUpdateTime = System.currentTimeMillis();
        }

        protected boolean isStillValid() {
            return this.lastUpdateTime + 3600000L > System.currentTimeMillis();
        }

        protected CertStore getCrlStore() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            if (!this.isStillValid()) {
                this.load();
            }
            return this.certStore;
        }
    }

    private static class ReloadableTrustStore {
        private final String casLocationPattern;
        private final KeyStore keyStore;
        private long lastUpdateTime;

        protected ReloadableTrustStore(String casLocationPattern) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
            this.casLocationPattern = casLocationPattern;
            this.keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
            this.reload();
        }

        private void reload() throws NoSuchAlgorithmException, CertificateException, IOException {
            this.keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(this.casLocationPattern));
            this.lastUpdateTime = System.currentTimeMillis();
        }

        protected boolean isStillValid() {
            return this.lastUpdateTime + 3600000L > System.currentTimeMillis();
        }

        protected KeyStore getTrustStore() throws NoSuchAlgorithmException, CertificateException, IOException {
            if (!this.isStillValid()) {
                this.reload();
            }
            return this.keyStore;
        }
    }
}

