/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.IOException;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.proxy.ext.ProxyCertInfo;

public final class ProxyCertificateUtil {
    private ProxyCertificateUtil() {
    }

    public static boolean isProxy(GSIConstants.CertificateType certType) {
        return ProxyCertificateUtil.isGsi2Proxy(certType) || ProxyCertificateUtil.isGsi3Proxy(certType) || ProxyCertificateUtil.isGsi4Proxy(certType);
    }

    public static boolean isGsi4Proxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY || certType == GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY || certType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY || certType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY;
    }

    public static boolean isGsi3Proxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY || certType == GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY || certType == GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY || certType == GSIConstants.CertificateType.GSI_3_LIMITED_PROXY;
    }

    public static boolean isGsi2Proxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_2_PROXY || certType == GSIConstants.CertificateType.GSI_2_LIMITED_PROXY;
    }

    public static boolean isLimitedProxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_3_LIMITED_PROXY || certType == GSIConstants.CertificateType.GSI_2_LIMITED_PROXY || certType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY;
    }

    public static boolean isIndependentProxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY || certType == GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY;
    }

    public static boolean isImpersonationProxy(GSIConstants.CertificateType certType) {
        return certType == GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY || certType == GSIConstants.CertificateType.GSI_3_LIMITED_PROXY || certType == GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY || certType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY || certType == GSIConstants.CertificateType.GSI_2_LIMITED_PROXY || certType == GSIConstants.CertificateType.GSI_2_PROXY;
    }

    public static int getProxyPathConstraint(TBSCertificateStructure crt) throws IOException {
        ProxyCertInfo proxyCertExt = ProxyCertificateUtil.getProxyCertInfo(crt);
        return proxyCertExt != null ? proxyCertExt.getPathLenConstraint() : -1;
    }

    public static ProxyCertInfo getProxyCertInfo(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension ext = extensions.getExtension(ProxyCertInfo.OID);
        if (ext == null) {
            ext = extensions.getExtension(ProxyCertInfo.OLD_OID);
        }
        return ext != null ? ProxyCertificateUtil.getProxyCertInfo(ext) : null;
    }

    public static ProxyCertInfo getProxyCertInfo(X509Extension ext) {
        byte[] value = ext.getValue().getOctets();
        return ProxyCertInfo.getInstance(value);
    }

    public static String getProxyTypeAsString(GSIConstants.CertificateType proxyType) {
        switch (proxyType) {
            case GSI_4_IMPERSONATION_PROXY: {
                return "RFC 3820 compliant impersonation proxy";
            }
            case GSI_4_INDEPENDENT_PROXY: {
                return "RFC 3820 compliant independent proxy";
            }
            case GSI_4_LIMITED_PROXY: {
                return "RFC 3820 compliant limited proxy";
            }
            case GSI_4_RESTRICTED_PROXY: {
                return "RFC 3820 compliant restricted proxy";
            }
            case GSI_3_IMPERSONATION_PROXY: {
                return "Proxy draft compliant impersonation proxy";
            }
            case GSI_3_INDEPENDENT_PROXY: {
                return "Proxy draft compliant independent proxy";
            }
            case GSI_3_LIMITED_PROXY: {
                return "Proxy draft compliant limited proxy";
            }
            case GSI_3_RESTRICTED_PROXY: {
                return "Proxy draft compliant restricted proxy";
            }
            case GSI_2_PROXY: {
                return "full legacy globus proxy";
            }
            case GSI_2_LIMITED_PROXY: {
                return "limited legacy globus proxy";
            }
        }
        return "not a proxy";
    }
}

