/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.HeaderTokenizer;
import org.apache.axiom.attachments.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractPart
implements Part {
    private static Log log = LogFactory.getLog(AbstractPart.class);
    private Hashtable headers;

    AbstractPart(Hashtable in) {
        this.headers = in;
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addHeader: (" + name + ") value=(" + value + ")"));
        }
        Header headerObj = new Header(name, value);
        String key = name.toLowerCase();
        this.headers.put(key, headerObj);
    }

    @Override
    public Enumeration getAllHeaders() throws MessagingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllHeaders");
        }
        return this.headers.elements();
    }

    @Override
    public String getHeader(String name) {
        String value;
        String key = name.toLowerCase();
        Header header = (Header)this.headers.get(key);
        String string = value = header == null ? null : header.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getHeader name=(" + name + ") value=(" + value + ")"));
        }
        return value;
    }

    @Override
    public String getContentID() throws MessagingException {
        return this.getHeader("content-id");
    }

    @Override
    public String getContentType() throws MessagingException {
        return this.getHeader("content-type");
    }

    public String getContentTransferEncoding() throws MessagingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getContentTransferEncoding()");
        }
        String cte = this.getHeader("content-transfer-encoding");
        if (log.isDebugEnabled()) {
            log.debug((Object)(" CTE =" + cte));
        }
        if (cte != null) {
            if ((cte = cte.trim()).equalsIgnoreCase("7bit") || cte.equalsIgnoreCase("8bit") || cte.equalsIgnoreCase("quoted-printable") || cte.equalsIgnoreCase("base64")) {
                return cte;
            }
            HeaderTokenizer ht = new HeaderTokenizer(cte, "()<>@,;:\\\"\t []/?=");
            boolean done = false;
            while (!done) {
                HeaderTokenizer.Token token = ht.next();
                switch (token.getType()) {
                    case -4: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"HeaderTokenizer EOF");
                        }
                        done = true;
                        break;
                    }
                    case -1: {
                        return token.getValue();
                    }
                }
            }
            return cte;
        }
        return null;
    }

    @Override
    public abstract DataHandler getDataHandler() throws MessagingException;

    @Override
    public abstract String getFileName() throws MessagingException;

    @Override
    public abstract InputStream getInputStream() throws IOException, MessagingException;

    @Override
    public abstract long getSize() throws MessagingException;
}

