/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public abstract class XmlInfosetBuilder {
    public static final String FEATURE_READ_ONLY = "org.xmlpull.infoset.feature.read.only";
    public static final String FEATURE_BUILD_COMMENTS = "org.xmlpull.infoset.feature.comments";
    public static final String FEATURE_BUILD_PROCESSING_INSTRUCTIONS = "org.xmlpull.infoset.feature.pis";
    public static final String FEATURE_WRAP_CHARACTERS = "org.xmlpull.infoset.feature.wrap.chars";
    public static final String FEATURE_VIEWS = "org.xmlpull.infoset.feature.views";
    public static final String FEATURE_BUILD_DOM2 = "org.xmlpull.infoset.feature.dom2";
    static final Class referenceContextClass = XmlInfosetBuilder.class;
    public static final String PROPERTY_NAME = "org.xmlpull.infoset.XmlInfosetBuilder";
    private static final String RESOURCE_NAME = "/META-INF/services/org.xmlpull.infoset.XmlInfosetBuilder";

    public static XmlInfosetBuilder newInstance() throws XmlBuilderException {
        return XmlInfosetBuilder.newInstance(null, null);
    }

    public static XmlInfosetBuilder newInstance(String classNames, Class context) throws XmlBuilderException {
        if (context == null) {
            context = referenceContextClass;
        }
        String classNamesLocation = null;
        if (classNames == null || classNames.length() == 0 || "DEFAULT".equals(classNames)) {
            String resourceContent = "<MISSING>";
            try {
                int ch;
                InputStream is = context.getResourceAsStream(RESOURCE_NAME);
                if (is == null) {
                    throw new XmlBuilderException("resource not found: /META-INF/services/org.xmlpull.infoset.XmlInfosetBuilder make sure that builder implementing XML Infoset API is available");
                }
                StringBuffer sb = new StringBuffer();
                while ((ch = is.read()) >= 0) {
                    if (ch <= 32) continue;
                    sb.append((char)ch);
                }
                is.close();
                resourceContent = sb.toString();
            }
            catch (Exception e) {
                throw new XmlBuilderException("Could not create XML Infoset of /META-INF/services/org.xmlpull.infoset.XmlInfosetBuilder (that  had '" + resourceContent + "'):" + e, e);
            }
            classNamesLocation = "resource /META-INF/services/org.xmlpull.infoset.XmlInfosetBuilder that contained '" + resourceContent + "'";
            classNames = resourceContent;
        } else {
            classNamesLocation = "parameter classNames to newInstance() that contained '" + classNames + "'";
        }
        XmlInfosetBuilder factory = null;
        int pos = 0;
        while (pos < classNames.length()) {
            int cut = classNames.indexOf(44, pos);
            if (cut == -1) {
                cut = classNames.length();
            }
            String name = classNames.substring(pos, cut);
            Class<?> candidate = null;
            Object instance = null;
            try {
                candidate = Class.forName(name);
                instance = candidate.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (candidate != null) {
                boolean recognized = false;
                if (instance instanceof XmlInfosetBuilder) {
                    if (factory == null) {
                        factory = instance;
                    }
                    recognized = true;
                }
                if (!recognized) {
                    throw new XmlBuilderException("incompatible class: " + name);
                }
            }
            pos = cut + 1;
        }
        if (factory == null) {
            throw new XmlBuilderException("no XML Infoset builder could be created out of " + classNamesLocation);
        }
        return factory;
    }

    public abstract void setFeature(String var1, boolean var2) throws XmlBuilderException;

    public XmlDocument newDocument() throws XmlBuilderException {
        return this.newDocument(null, null, null);
    }

    public abstract XmlDocument newDocument(String var1, Boolean var2, String var3) throws XmlBuilderException;

    public abstract XmlElement newFragment(String var1) throws XmlBuilderException;

    public abstract XmlElement newFragment(String var1, String var2) throws XmlBuilderException;

    public abstract XmlElement newFragment(XmlNamespace var1, String var2) throws XmlBuilderException;

    public abstract XmlNamespace newNamespace(String var1) throws XmlBuilderException;

    public abstract XmlNamespace newNamespace(String var1, String var2) throws XmlBuilderException;

    public abstract XmlDocument parseInputStream(InputStream var1) throws XmlBuilderException;

    public abstract XmlDocument parseInputStream(InputStream var1, String var2) throws XmlBuilderException;

    public abstract XmlDocument parseReader(Reader var1) throws XmlBuilderException;

    public XmlDocument parseString(String xmlAsString) throws XmlBuilderException {
        return this.parseReader(new StringReader(xmlAsString));
    }

    public abstract XmlDocument parseLocation(String var1) throws XmlBuilderException;

    public abstract XmlElement parseFragmentFromInputStream(InputStream var1) throws XmlBuilderException;

    public abstract XmlElement parseFragmentFromInputStream(InputStream var1, String var2) throws XmlBuilderException;

    public abstract XmlElement parseFragmentFromReader(Reader var1) throws XmlBuilderException;

    public XmlElement parseFragmentFromString(String xmlAsString) throws XmlBuilderException {
        return this.parseFragmentFromReader(new StringReader(xmlAsString));
    }

    public void serializeToOutputStream(Object item, OutputStream os) throws XmlBuilderException {
        this.serializeToOutputStream(item, os, "UTF8");
    }

    public abstract void serializeToOutputStream(Object var1, OutputStream var2, String var3) throws XmlBuilderException;

    public abstract void serializeToWriter(Object var1, Writer var2) throws XmlBuilderException;

    public abstract void serializeToWriter(Object var1, Writer var2, boolean var3) throws XmlBuilderException;

    public String serializeToString(Object item) throws XmlBuilderException {
        StringWriter sw = new StringWriter();
        this.serializeToWriter(item, sw);
        return sw.toString();
    }

    public String serializeToStringPretty(Object item) throws XmlBuilderException {
        StringWriter sw = new StringWriter();
        this.serializeToWriter(item, sw, true);
        return sw.toString();
    }
}

