/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client;

import java.util.HashSet;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.AuroraSchedulerClientFactory;
import org.apache.airavata.cloud.aurora.client.bean.GetJobsResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.JobConfigBean;
import org.apache.airavata.cloud.aurora.client.bean.JobDetailsResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.JobKeyBean;
import org.apache.airavata.cloud.aurora.client.bean.PendingJobReasonBean;
import org.apache.airavata.cloud.aurora.client.bean.ResponseBean;
import org.apache.airavata.cloud.aurora.client.sdk.AuroraSchedulerManager;
import org.apache.airavata.cloud.aurora.client.sdk.JobConfiguration;
import org.apache.airavata.cloud.aurora.client.sdk.JobKey;
import org.apache.airavata.cloud.aurora.client.sdk.ReadOnlyScheduler;
import org.apache.airavata.cloud.aurora.client.sdk.Response;
import org.apache.airavata.cloud.aurora.client.sdk.TaskQuery;
import org.apache.airavata.cloud.aurora.util.AuroraThriftClientUtil;
import org.apache.airavata.cloud.aurora.util.ResponseResultType;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuroraThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AuroraThriftClient.class);
    private ReadOnlyScheduler.Client readOnlySchedulerClient = null;
    private AuroraSchedulerManager.Client auroraSchedulerManagerClient = null;
    private static AuroraThriftClient thriftClient = null;

    private AuroraThriftClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuroraThriftClient getAuroraThriftClient() throws Exception {
        try {
            if (thriftClient != null) return thriftClient;
            Class<AuroraThriftClient> clazz = AuroraThriftClient.class;
            synchronized (AuroraThriftClient.class) {
                if (thriftClient != null) return thriftClient;
                thriftClient = new AuroraThriftClient();
                String auroraHosts = ServerSettings.getAuroraSchedulerHosts();
                Integer connectTimeout = ServerSettings.getAuroraSchedulerTimeout();
                if (auroraHosts == null || auroraHosts.trim().isEmpty()) throw new Exception("Aurora hosts not specified in airavata-server.properties file.");
                auroraHosts = auroraHosts.trim();
                for (String auroraHost : auroraHosts.split(",")) {
                    String port;
                    if (auroraHost.split(":").length != 2) {
                        throw new Exception("Scheduler Host String: " + auroraHost + ", is malformed. Should be of form <hostname:port>!");
                    }
                    String hostname = auroraHost.split(":")[0];
                    String connectionUrl = String.format("http://%s:%s/api", hostname, port = auroraHost.split(":")[1]);
                    if (!AuroraThriftClientUtil.isSchedulerHostReachable(connectionUrl, connectTimeout)) continue;
                    AuroraThriftClient.thriftClient.readOnlySchedulerClient = AuroraSchedulerClientFactory.createReadOnlySchedulerClient(connectionUrl, connectTimeout);
                    AuroraThriftClient.thriftClient.auroraSchedulerManagerClient = AuroraSchedulerClientFactory.createSchedulerManagerClient(connectionUrl, connectTimeout);
                    break;
                }
                if (AuroraThriftClient.thriftClient.auroraSchedulerManagerClient != null && AuroraThriftClient.thriftClient.readOnlySchedulerClient != null) return thriftClient;
                throw new Exception("None of the Aurora scheduler hosts : <" + auroraHosts + "> were reachable, hence connection not established!");
            }
        }
        catch (Exception ex) {
            logger.error("Couldn't initialize Aurora thrift client", (Throwable)ex);
            throw ex;
        }
    }

    private boolean reconnectWithAuroraScheduler() {
        boolean connectionSuccess;
        block5: {
            connectionSuccess = false;
            try {
                String auroraHosts = ServerSettings.getAuroraSchedulerHosts();
                Integer connectTimeout = ServerSettings.getAuroraSchedulerTimeout();
                if (auroraHosts != null) {
                    for (String auroraHost : auroraHosts.split(",")) {
                        if (auroraHost.split(":").length != 2) {
                            throw new Exception("Scheduler Host String: " + auroraHost + ", is malformed. Should be of form <hostname:port>!");
                        }
                        String hostname = auroraHost.split(":")[0];
                        String port = auroraHost.split(":")[1];
                        String connectionUrl = String.format("http://%s:%s/api", hostname, port);
                        if (!AuroraThriftClientUtil.isSchedulerHostReachable(connectionUrl, connectTimeout)) continue;
                        AuroraThriftClient.thriftClient.readOnlySchedulerClient = AuroraSchedulerClientFactory.createReadOnlySchedulerClient(connectionUrl, connectTimeout);
                        AuroraThriftClient.thriftClient.auroraSchedulerManagerClient = AuroraSchedulerClientFactory.createSchedulerManagerClient(connectionUrl, connectTimeout);
                        connectionSuccess = true;
                    }
                    break block5;
                }
                throw new Exception("Aurora hosts not specified in airavata-server.properties file.");
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return connectionSuccess;
    }

    public ResponseBean createJob(JobConfigBean jobConfigBean) throws Exception {
        ResponseBean response = null;
        while (response == null) {
            try {
                if (jobConfigBean == null) continue;
                JobConfiguration jobConfig = AuroraThriftClientUtil.getAuroraJobConfig(jobConfigBean);
                Response createJobResponse = this.auroraSchedulerManagerClient.createJob(jobConfig);
                response = AuroraThriftClientUtil.getResponseBean(createJobResponse, ResponseResultType.CREATE_JOB);
            }
            catch (Exception ex) {
                if (ex instanceof TTransportException && this.reconnectWithAuroraScheduler()) continue;
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return response;
    }

    public ResponseBean killTasks(JobKeyBean jobKeyBean, Set<Integer> instances) throws Exception {
        ResponseBean response = null;
        while (response == null) {
            try {
                if (jobKeyBean == null) continue;
                JobKey jobKey = AuroraThriftClientUtil.getAuroraJobKey(jobKeyBean);
                Response killTaskResponse = this.auroraSchedulerManagerClient.killTasks(jobKey, instances);
                response = AuroraThriftClientUtil.getResponseBean(killTaskResponse, ResponseResultType.KILL_TASKS);
            }
            catch (Exception ex) {
                if (ex instanceof TTransportException && this.reconnectWithAuroraScheduler()) continue;
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return response;
    }

    public GetJobsResponseBean getJobList(String ownerRole) throws Exception {
        GetJobsResponseBean response = null;
        while (response == null) {
            try {
                Response jobListResponse = this.readOnlySchedulerClient.getJobs(ownerRole);
                response = (GetJobsResponseBean)AuroraThriftClientUtil.getResponseBean(jobListResponse, ResponseResultType.GET_JOBS);
            }
            catch (Exception ex) {
                if (ex instanceof TTransportException && this.reconnectWithAuroraScheduler()) continue;
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return response;
    }

    public PendingJobReasonBean getPendingReasonForJob(JobKeyBean jobKeyBean) throws Exception {
        PendingJobReasonBean response = null;
        while (response == null) {
            try {
                JobKey jobKey = AuroraThriftClientUtil.getAuroraJobKey(jobKeyBean);
                HashSet<JobKey> jobKeySet = new HashSet<JobKey>();
                jobKeySet.add(jobKey);
                TaskQuery query = new TaskQuery();
                query.setJobKeys(jobKeySet);
                Response pendingReasonResponse = this.readOnlySchedulerClient.getPendingReason(query);
                response = (PendingJobReasonBean)AuroraThriftClientUtil.getResponseBean(pendingReasonResponse, ResponseResultType.GET_PENDING_JOB_REASON);
            }
            catch (Exception ex) {
                if (ex instanceof TTransportException && this.reconnectWithAuroraScheduler()) continue;
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return response;
    }

    public JobDetailsResponseBean getJobDetails(JobKeyBean jobKeyBean) throws Exception {
        JobDetailsResponseBean response = null;
        while (response == null) {
            try {
                if (jobKeyBean == null) continue;
                JobKey jobKey = AuroraThriftClientUtil.getAuroraJobKey(jobKeyBean);
                HashSet<JobKey> jobKeySet = new HashSet<JobKey>();
                jobKeySet.add(jobKey);
                TaskQuery query = new TaskQuery();
                query.setJobKeys(jobKeySet);
                Response jobDetailsResponse = this.readOnlySchedulerClient.getTasksStatus(query);
                response = (JobDetailsResponseBean)AuroraThriftClientUtil.getResponseBean(jobDetailsResponse, ResponseResultType.GET_JOB_DETAILS);
            }
            catch (Exception ex) {
                if (ex instanceof TTransportException && this.reconnectWithAuroraScheduler()) continue;
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return response;
    }
}

