/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.api.server;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.server.handler.AiravataServerHandler;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.error.AiravataErrorType;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.AiravataSecurityManager;
import org.apache.airavata.service.security.SecurityManagerFactory;
import org.apache.airavata.service.security.interceptor.SecurityModule;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataAPIServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(AiravataAPIServer.class);
    private static final String SERVER_NAME = "Airavata API Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;
    private TServer TLSServer;

    public AiravataAPIServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public void startAiravataServer(Airavata.Processor<Airavata.Iface> airavataAPIServer) throws AiravataSystemException {
        try {
            String serverHost = ServerSettings.getSetting((String)"apiserver.host", null);
            if (!ServerSettings.isTLSEnabled()) {
                TServerSocket serverTransport;
                final int serverPort = Integer.parseInt(ServerSettings.getSetting((String)"apiserver.port", (String)"8930"));
                if (ServerSettings.isAPIServerTLSEnabled()) {
                    logger.info("Starting API Server with TLS Security..");
                    String keystore = ServerSettings.getApiServerKeystore();
                    String keystorePWD = ServerSettings.getApiServerKeystorePasswd();
                    TSSLTransportFactory.TSSLTransportParameters tlsParams = new TSSLTransportFactory.TSSLTransportParameters();
                    tlsParams.setKeyStore(keystore, keystorePWD);
                    serverTransport = TSSLTransportFactory.getServerSocket((int)serverPort, (int)10000, (InetAddress)InetAddress.getByName(serverHost), (TSSLTransportFactory.TSSLTransportParameters)tlsParams);
                } else if (serverHost == null) {
                    serverTransport = new TServerSocket(serverPort);
                } else {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                    serverTransport = new TServerSocket(inetSocketAddress);
                }
                TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
                options.minWorkerThreads = Integer.parseInt(ServerSettings.getSetting((String)"apiserver.server.min.threads", (String)"50"));
                this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor(airavataAPIServer));
                new Thread(){

                    @Override
                    public void run() {
                        AiravataAPIServer.this.server.serve();
                        AiravataAPIServer.this.setStatus(IServer.ServerStatus.STOPPED);
                        logger.info("Airavata API Server Stopped.");
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        while (!AiravataAPIServer.this.server.isServing()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (AiravataAPIServer.this.server.isServing()) {
                            AiravataAPIServer.this.setStatus(IServer.ServerStatus.STARTED);
                            logger.info("Starting Airavata API Server on Port " + serverPort);
                            logger.info("Listening to Airavata Clients ....");
                        }
                    }
                }.start();
                logger.info("Started API Server ....");
            } else {
                TSSLTransportFactory.TSSLTransportParameters TLSParams = new TSSLTransportFactory.TSSLTransportParameters();
                TLSParams.setKeyStore(ServerSettings.getKeyStorePath(), ServerSettings.getKeyStorePassword());
                TServerSocket TLSServerTransport = TSSLTransportFactory.getServerSocket((int)ServerSettings.getTLSServerPort(), (int)ServerSettings.getTLSClientTimeout(), (InetAddress)InetAddress.getByName(serverHost), (TSSLTransportFactory.TSSLTransportParameters)TLSParams);
                TThreadPoolServer.Args settings = new TThreadPoolServer.Args((TServerTransport)TLSServerTransport);
                settings.minWorkerThreads = Integer.parseInt(ServerSettings.getSetting((String)"apiserver.server.min.threads", (String)"50"));
                this.TLSServer = new TThreadPoolServer((TThreadPoolServer.Args)settings.processor(airavataAPIServer));
                new Thread(){

                    @Override
                    public void run() {
                        AiravataAPIServer.this.TLSServer.serve();
                        AiravataAPIServer.this.setStatus(IServer.ServerStatus.STOPPED);
                        logger.info("Airavata API Server over TLS Stopped.");
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        while (!AiravataAPIServer.this.TLSServer.isServing()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (AiravataAPIServer.this.TLSServer.isServing()) {
                            AiravataAPIServer.this.setStatus(IServer.ServerStatus.STARTED);
                        }
                    }
                }.start();
                logger.info("API server started over TLS on Port: " + ServerSettings.getTLSServerPort() + " ...");
            }
            AiravataSecurityManager securityManager = SecurityManagerFactory.getSecurityManager();
            securityManager.initializeSecurityInfra();
        }
        catch (TTransportException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.setStatus(IServer.ServerStatus.FAILED);
            logger.error("Failed to start API server ...");
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        catch (AiravataSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
    }

    public static void main(String[] args) {
        try {
            AiravataAPIServer server = new AiravataAPIServer();
            server.start();
        }
        catch (Exception e) {
            logger.error("Error while initializing Airavata API server", (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.setStatus(IServer.ServerStatus.STARTING);
        Injector injector = Guice.createInjector((Module[])new Module[]{new SecurityModule()});
        Airavata.Processor airavataAPIServer = new Airavata.Processor((Airavata.Iface)injector.getInstance(AiravataServerHandler.class));
        this.startAiravataServer((Airavata.Processor<Airavata.Iface>)airavataAPIServer);
    }

    public void stop() throws Exception {
        if (!ServerSettings.isTLSEnabled() && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
        if (ServerSettings.isTLSEnabled() && this.TLSServer.isServing()) {
            this.TLSServer.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }
}

