/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AtomicLongBackupAwareOperation;
import com.hazelcast.concurrent.atomiclong.SetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CompareAndSetOperation
extends AtomicLongBackupAwareOperation {
    private long expect;
    private long update;
    private boolean returnValue = false;

    public CompareAndSetOperation() {
    }

    public CompareAndSetOperation(String name, long expect, long update) {
        super(name);
        this.expect = expect;
        this.update = update;
    }

    @Override
    public void run() throws Exception {
        this.returnValue = this.getNumber().compareAndSet(this.expect, this.update);
        this.shouldBackup = !this.returnValue;
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.expect);
        out.writeLong(this.update);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expect = in.readLong();
        this.update = in.readLong();
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.update);
    }
}

