/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AtomicLongBackupAwareOperation;
import com.hazelcast.concurrent.atomiclong.SetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class GetAndSetOperation
extends AtomicLongBackupAwareOperation {
    private long newValue;
    private long returnValue;

    public GetAndSetOperation() {
    }

    public GetAndSetOperation(String name, long newValue) {
        super(name);
        this.newValue = newValue;
    }

    @Override
    public void run() throws Exception {
        this.returnValue = this.getNumber().getAndSet(this.newValue);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.newValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newValue = in.readLong();
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.newValue);
    }
}

