/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManagementCenterIdentifier
implements Serializable {
    private int version;
    private String clusterName;
    private String address;
    public transient String versionString;

    public ManagementCenterIdentifier() {
    }

    public ManagementCenterIdentifier(String version, String clusterName, String address) {
        this.version = ManagementCenterIdentifier.getVersionAsInt(version);
        this.clusterName = clusterName;
        this.address = address;
    }

    public static int getVersionAsInt(String versionString) throws IllegalArgumentException {
        int version = 0;
        Pattern pattern = Pattern.compile("^(\\d)\\.(\\d)(?:\\.(\\d))?+.*");
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.matches()) {
            for (int i = 1; i < matcher.groupCount() + 1; ++i) {
                version *= 10;
                version += Integer.parseInt(matcher.group(i) == null ? "0" : matcher.group(i));
            }
            return version;
        }
        throw new IllegalArgumentException(String.format("version string '%s' is not valid", versionString));
    }

    public static String convertVersionToString(int version) {
        StringBuilder builder = new StringBuilder();
        String v = Integer.toString(version);
        builder.append(v.charAt(0));
        builder.append('.');
        builder.append(v.charAt(1));
        builder.append('.');
        builder.append(v.charAt(2));
        return builder.toString();
    }

    public void read(InputStream in) throws IOException {
        DataInputStream dataInput = new DataInputStream(in);
        this.version = dataInput.readInt();
        this.clusterName = dataInput.readUTF();
        this.address = dataInput.readUTF();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(out);
        dataOutput.writeInt(this.version);
        dataOutput.writeUTF(this.clusterName);
        dataOutput.writeUTF(this.address);
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionString() {
        if (this.versionString == null) {
            this.versionString = ManagementCenterIdentifier.convertVersionToString(this.version);
        }
        return this.versionString;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getAddress() {
        return this.address;
    }
}

