/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NearCache {
    final int evictionPercentage = 20;
    final int cleanupInterval = 5000;
    final int maxSize;
    volatile long lastCleanup;
    final long maxIdleMillis;
    final long timeToLiveMillis;
    final boolean invalidateOnChange;
    final EvictionPolicy evictionPolicy;
    final MapConfig.InMemoryFormat inMemoryFormat;
    final String mapName;
    final MapService mapService;
    final NodeEngine nodeEngine;
    final AtomicBoolean canCleanUp;
    final AtomicBoolean canEvict;
    final ConcurrentMap<Data, CacheRecord> cache;

    public NearCache(String mapName, MapService mapService) {
        this.mapName = mapName;
        this.mapService = mapService;
        this.nodeEngine = mapService.getNodeEngine();
        Config config = this.nodeEngine.getConfig();
        NearCacheConfig nearCacheConfig = config.getMapConfig(mapName).getNearCacheConfig();
        this.maxSize = nearCacheConfig.getMaxSize() <= 0 ? Integer.MAX_VALUE : nearCacheConfig.getMaxSize();
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.cache = new ConcurrentHashMap<Data, CacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
    }

    public void put(Data key, Data data) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        Data value = this.inMemoryFormat.equals((Object)MapConfig.InMemoryFormat.BINARY) ? data : this.mapService.toObject(data);
        this.cache.put(key, new CacheRecord(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute("hz:near-cache", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(NearCache.this.cache.values());
                            int evictSize = NearCache.this.cache.size() * 20 / 100;
                            int i = 0;
                            for (CacheRecord record : records) {
                                NearCache.this.cache.remove(record.key);
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            NearCache.this.canEvict.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute("hz:near-cache", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : NearCache.this.cache.entrySet()) {
                                if (!((CacheRecord)entry.getValue()).expired()) continue;
                                NearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            NearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    public Object get(Data key) {
        this.fireTtlCleanup();
        CacheRecord record = (CacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.expired()) {
                this.cache.remove(key);
                return null;
            }
            return record.value;
        }
        return null;
    }

    public void invalidate(Data key) {
        this.cache.remove(key);
    }

    void clear() {
        this.cache.clear();
    }

    class CacheRecord
    implements Comparable<CacheRecord> {
        final Data key;
        final Object value;
        volatile long lastAccessTime;
        final long creationTime;
        final AtomicInteger hit;

        CacheRecord(Data key, Object value) {
            long time;
            this.key = key;
            this.value = value;
            this.lastAccessTime = time = Clock.currentTimeMillis();
            this.creationTime = time;
            this.hit = new AtomicInteger(0);
        }

        void access() {
            this.hit.incrementAndGet();
            this.lastAccessTime = Clock.currentTimeMillis();
        }

        boolean expired() {
            long time = Clock.currentTimeMillis();
            return NearCache.this.maxIdleMillis > 0L && time > this.lastAccessTime + NearCache.this.maxIdleMillis || NearCache.this.timeToLiveMillis > 0L && time > this.creationTime + NearCache.this.timeToLiveMillis;
        }

        @Override
        public int compareTo(CacheRecord o) {
            if (EvictionPolicy.LRU.equals((Object)NearCache.this.evictionPolicy)) {
                return Long.valueOf(this.lastAccessTime).compareTo(o.lastAccessTime);
            }
            if (EvictionPolicy.LFU.equals((Object)NearCache.this.evictionPolicy)) {
                return Integer.valueOf(this.hit.get()).compareTo(o.hit.get());
            }
            return 0;
        }
    }

    static enum EvictionPolicy {
        NONE,
        LRU,
        LFU;

    }
}

