/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.proxy;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.Iterator;

public class QueueIterator<E>
implements Iterator<E> {
    final Iterator<Data> iter;
    final SerializationService serializationService;
    final boolean binary;

    public QueueIterator(Iterator<Data> iter, SerializationService serializationService, boolean binary) {
        this.iter = iter;
        this.serializationService = serializationService;
        this.binary = binary;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public E next() {
        Data data = this.iter.next();
        if (this.binary) {
            return (E)data;
        }
        return (E)this.serializationService.toObject(data);
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

