/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import javax.xml.ws.AsyncHandler;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.async.CallbackFuture;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CallbackFutureTask
implements Callable {
    private static final Log log = LogFactory.getLog(CallbackFutureTask.class);
    private static final boolean debug = log.isDebugEnabled();
    AsyncResponse response;
    MessageContext msgCtx;
    AsyncHandler handler;
    ClassLoader handlerCL;
    Exception error;
    boolean done = false;

    CallbackFutureTask(AsyncResponse r, AsyncHandler h, ClassLoader cl) {
        this.response = r;
        this.handler = h;
        this.handlerCL = cl;
    }

    protected AsyncHandler getHandler() {
        return this.handler;
    }

    void setMessageContext(MessageContext mc) {
        this.msgCtx = mc;
    }

    void setError(Exception e) {
        this.error = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        CallbackFutureTask callbackFutureTask;
        ClassLoader oldCL = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting up the thread's context classLoader");
                log.debug((Object)this.handlerCL.toString());
            }
            oldCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(CallbackFutureTask.this.handlerCL);
                    return null;
                }
            });
            if (this.error != null) {
                this.response.onError(this.error, this.msgCtx, this.handlerCL);
            } else {
                this.response.onComplete(this.msgCtx, this.handlerCL);
            }
            if (debug) {
                log.debug((Object)("Calling JAX-WS AsyncHandler.handleResponse() with response object: " + CallbackFuture.displayHandle(this.response)));
            }
            this.handler.handleResponse(this.response);
            if (debug) {
                log.debug((Object)"Returned from handleResponse() invocation...");
            }
            callbackFutureTask = this;
        }
        catch (Throwable t) {
            CallbackFutureTask callbackFutureTask2;
            try {
                if (debug) {
                    log.debug((Object)"An error occurred while invoking the callback object.");
                    log.debug((Object)("Error: " + t.toString()));
                    t.printStackTrace();
                }
                callbackFutureTask2 = this;
            }
            catch (Throwable throwable) {
                CallbackFutureTask callbackFutureTask3 = this;
                synchronized (callbackFutureTask3) {
                    if (oldCL != null) {
                        ClassLoader t2 = oldCL;
                        AccessController.doPrivileged(new PrivilegedAction(t2){
                            final /* synthetic */ ClassLoader val$t;
                            {
                                this.val$t = classLoader;
                            }

                            public Object run() {
                                Thread.currentThread().setContextClassLoader(this.val$t);
                                return null;
                            }
                        });
                        if (debug) {
                            log.debug((Object)("Restored thread context classloader: " + oldCL.toString()));
                        }
                    }
                    this.done = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (callbackFutureTask2) {
                if (oldCL != null) {
                    ClassLoader t3 = oldCL;
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    if (debug) {
                        log.debug((Object)("Restored thread context classloader: " + oldCL.toString()));
                    }
                }
                this.done = true;
                this.notifyAll();
            }
        }
        synchronized (callbackFutureTask) {
            if (oldCL != null) {
                ClassLoader t = oldCL;
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                if (debug) {
                    log.debug((Object)("Restored thread context classloader: " + oldCL.toString()));
                }
            }
            this.done = true;
            this.notifyAll();
        }
        return null;
    }
}

