/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.mex.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.mex.MexException;
import org.apache.axis2.mex.om.IMexOM;
import org.apache.axis2.mex.om.MetadataSection;
import org.apache.axis2.mex.om.MexOM;
import org.apache.axis2.mex.om.MexOMException;
import org.apache.axis2.mex.util.MexUtil;

public class Metadata
extends MexOM
implements IMexOM {
    private String namespaceValue = null;
    private OMFactory factory;
    private List metadataSections = new ArrayList();
    private OMAttribute attribute = null;

    public Metadata() throws MexException {
        this.factory = MexUtil.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        this.namespaceValue = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    }

    public Metadata(OMFactory defaultFactory, String namespaceValue) throws MexOMException {
        this.factory = defaultFactory;
        this.namespaceValue = namespaceValue;
    }

    public MetadataSection[] getMetadatSections() {
        return this.metadataSections.toArray(new MetadataSection[0]);
    }

    public MetadataSection[] getMetadataSection(String dialect, String identifier) {
        MetadataSection[] sections = this.getMetadataSection(dialect, identifier, null);
        return sections;
    }

    public MetadataSection[] getMetadataSection(String dialect, String identifier, OutputForm form) {
        Iterator sections = this.metadataSections.iterator();
        ArrayList<MetadataSection> foundSections = new ArrayList<MetadataSection>();
        while (sections.hasNext()) {
            MetadataSection aSection = (MetadataSection)sections.next();
            if (dialect != null && !dialect.equals(aSection.getDialect()) || identifier != null && !dialect.equals(aSection.getIdentifier()) || !this.matchOutputForm(aSection, form)) continue;
            foundSections.add(aSection);
        }
        return foundSections.toArray(new MetadataSection[0]);
    }

    public Metadata fromOM(OMElement inElement) throws MexOMException {
        Iterator mexSections;
        OMFactory aFactory;
        OMElement mexElement = null;
        if (inElement == null) {
            throw new MexOMException("Null element passed.");
        }
        if (inElement.getLocalName().equals("Metadata")) {
            mexElement = inElement;
        }
        if (inElement.getLocalName().equals("EndpointReference")) {
            block12: {
                try {
                    EndpointReference epr = EndpointReferenceHelper.fromOM(inElement);
                    ArrayList<OMNode> metadata = epr.getMetaData();
                    if (metadata != null) {
                        mexElement = (OMElement)metadata.get(0);
                        break block12;
                    }
                    ArrayList<OMElement> refParm = epr.getExtensibleElements();
                    for (int i = 0; i < refParm.size(); ++i) {
                        OMElement elem = refParm.get(i);
                        if (!elem.getLocalName().equals("Metadata")) continue;
                        mexElement = elem;
                        break;
                    }
                }
                catch (AxisFault e) {
                    throw new MexOMException(e);
                }
            }
            if (mexElement == null) {
                throw new MexOMException("Missing expected Metadata element in element passed.");
            }
        } else {
            mexElement = inElement;
        }
        if ((aFactory = mexElement.getOMFactory()) == null) {
            aFactory = this.factory;
        }
        if ((mexSections = mexElement.getChildrenWithName(new QName(this.namespaceValue, "MetadataSection"))) == null) {
            throw new MexOMException("Metadata element does not contain MetadataSection element.");
        }
        while (mexSections.hasNext()) {
            OMElement aSection = (OMElement)mexSections.next();
            MetadataSection metadataSection = new MetadataSection(aFactory, this.namespaceValue);
            this.addMetadatSection(metadataSection.fromOM(aSection));
        }
        return this;
    }

    public OMElement toOM() throws MexOMException {
        OMNamespace mexNamespace = this.factory.createOMNamespace(this.namespaceValue, "mex");
        OMElement metadata = this.factory.createOMElement("Metadata", mexNamespace);
        for (MetadataSection aSection : this.metadataSections) {
            metadata.addChild((OMNode)aSection.toOM());
        }
        if (this.attribute != null) {
            metadata.addAttribute(this.attribute);
        }
        return metadata;
    }

    public void setMetadatSections(List in_metadataSections) {
        this.metadataSections = in_metadataSections;
    }

    public void addMetadatSections(List in_metadataSections) {
        Iterator sections = in_metadataSections.iterator();
        while (sections.hasNext()) {
            this.addMetadatSection((MetadataSection)sections.next());
        }
    }

    public void addMetadatSection(MetadataSection section) {
        this.metadataSections.add(section);
    }

    public void setAttribute(OMAttribute in_attribute) {
        this.attribute = in_attribute;
    }

    private boolean matchOutputForm(MetadataSection section, OutputForm outputForm) {
        boolean match;
        boolean bl = match = outputForm == null;
        if (!match) {
            if (outputForm == OutputForm.LOCATION_FORM) {
                match = section.getLocation() != null;
            } else if (outputForm == OutputForm.REFERENCE_FORM) {
                match = section.getMetadataReference() != null;
            } else if (outputForm == OutputForm.INLINE_FORM) {
                match = section.getInlineData() != null;
            }
        }
        return match;
    }
}

