/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derby.drda.NetworkServerControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyUtil {
    private static NetworkServerControl server;
    private static final Logger logger;
    public static final String DERBY_SERVER_MODE_SYS_PROPERTY = "derby.drda.startNetworkServer";

    public static void startDerbyInServerMode(String hostAddress, int port, String user, String password) throws Exception {
        try (PrintWriter consoleWriter = null;){
            System.setProperty(DERBY_SERVER_MODE_SYS_PROPERTY, "true");
            server = new NetworkServerControl(InetAddress.getByName(hostAddress), port, user, password);
            consoleWriter = new PrintWriter(System.out, true);
            server.start(consoleWriter);
        }
    }

    public static void startDerbyInEmbeddedMode() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        DriverManager.getConnection("jdbc:derby:memory:unit-testing-jpa;create=true").close();
    }

    public static void stopDerbyServer() throws Exception {
        try {
            server.shutdown();
        }
        catch (Exception e) {
            logger.error("Error shutting down derby server.", (Throwable)e);
            throw e;
        }
    }

    static {
        logger = LoggerFactory.getLogger(DerbyUtil.class);
    }
}

