/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.airavata.common.utils.KeyStorePasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    public static final String PASSWORD_HASH_METHOD_PLAINTEXT = "PLAINTEXT";
    public static final String CHARSET_ENCODING = "UTF-8";
    public static final String ENCRYPTION_ALGORITHM = "AES";
    public static final String PADDING_MECHANISM = "AES/CBC/PKCS5Padding";
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtil.class);

    public static String digestString(String stringToDigest, String digestingAlgorithm) throws NoSuchAlgorithmException {
        if (digestingAlgorithm == null || digestingAlgorithm.equals(PASSWORD_HASH_METHOD_PLAINTEXT)) {
            return stringToDigest;
        }
        MessageDigest messageDigest = MessageDigest.getInstance(digestingAlgorithm);
        try {
            return new String(messageDigest.digest(stringToDigest.getBytes(CHARSET_ENCODING)));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error encoding password string when creating digest", (Throwable)e);
            throw new RuntimeException("Error encoding password string when creating digest", e);
        }
    }

    public static void setTrustStoreParameters(String trustStoreFilePath, String trustStorePassword) {
        if (System.getProperty("javax.net.ssl.trustStrore") == null) {
            logger.info("Setting Java trust store to " + trustStoreFilePath);
            System.setProperty("javax.net.ssl.trustStrore", trustStoreFilePath);
        }
        if (System.getProperty("javax.net.ssl.trustStorePassword") == null) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStoreFilePath);
        }
    }

    public static byte[] encryptString(String keyStorePath, String keyAlias, KeyStorePasswordCallback passwordCallback, String value) throws GeneralSecurityException, IOException {
        return SecurityUtil.encrypt(keyStorePath, keyAlias, passwordCallback, value.getBytes(CHARSET_ENCODING));
    }

    public static byte[] encrypt(String keyStorePath, String keyAlias, KeyStorePasswordCallback passwordCallback, byte[] value) throws GeneralSecurityException, IOException {
        Key secretKey = SecurityUtil.getSymmetricKey(keyStorePath, keyAlias, passwordCallback);
        Cipher cipher = Cipher.getInstance(PADDING_MECHANISM);
        cipher.init(1, secretKey, new IvParameterSpec(new byte[16]));
        return cipher.doFinal(value);
    }

    private static Key getSymmetricKey(String keyStorePath, String keyAlias, KeyStorePasswordCallback passwordCallback) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyStore ks = SecurityUtil.loadKeyStore(keyStorePath, "jceks", passwordCallback);
        if (ks == null) {
            throw new IOException("Unable to load Java keystore " + keyStorePath);
        }
        return ks.getKey(keyAlias, passwordCallback.getSecretKeyPassPhrase(keyAlias));
    }

    public static byte[] decrypt(String keyStorePath, String keyAlias, KeyStorePasswordCallback passwordCallback, byte[] encrypted) throws GeneralSecurityException, IOException {
        Key secretKey = SecurityUtil.getSymmetricKey(keyStorePath, keyAlias, passwordCallback);
        Cipher cipher = Cipher.getInstance(PADDING_MECHANISM);
        cipher.init(2, secretKey, new IvParameterSpec(new byte[16]));
        return cipher.doFinal(encrypted);
    }

    public static String decryptString(String keyStorePath, String keyAlias, KeyStorePasswordCallback passwordCallback, byte[] encrypted) throws GeneralSecurityException, IOException {
        byte[] decrypted = SecurityUtil.decrypt(keyStorePath, keyAlias, passwordCallback, encrypted);
        return new String(decrypted, CHARSET_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String keyStoreFilePath, String keyStoreType, KeyStorePasswordCallback passwordCallback) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(keyStoreFilePath);
            KeyStore keyStore = SecurityUtil.loadKeyStore(fis, keyStoreType, passwordCallback);
            return keyStore;
        }
    }

    public static KeyStore loadKeyStore(InputStream inputStream, String keyStoreType, KeyStorePasswordCallback passwordCallback) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(inputStream, passwordCallback.getStorePassword());
        return ks;
    }
}

