/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.xsem.SimpleXmlValueConverter;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyMapping;

public class LateBindingXsemMappingProcessor
implements MappingProcessor {
    private PropertyNamingStrategy namingStrategy;
    private ConverterLookup converterLookup;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.namingStrategy = namingStrategy;
        this.converterLookup = converterLookup;
        compassMapping.setPath(namingStrategy.getRootPath());
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            if (!(m instanceof XmlObjectMapping)) continue;
            this.secondPass((XmlObjectMapping)m, compassMapping);
        }
        return compassMapping;
    }

    private void secondPass(XmlObjectMapping xmlObjectMapping, CompassMapping fatherMapping) {
        xmlObjectMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), xmlObjectMapping.getAlias()));
        Iterator it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping mapping = (Mapping)it.next();
            if (mapping instanceof XmlIdMapping) {
                XmlIdMapping xmlIdMapping = (XmlIdMapping)mapping;
                xmlIdMapping.setInternal(true);
                xmlIdMapping.setPath(this.namingStrategy.buildPath(xmlObjectMapping.getPath(), xmlIdMapping.getName()));
            }
            if (!(mapping instanceof XmlPropertyMapping)) continue;
            XmlPropertyMapping xmlPropertyMapping = (XmlPropertyMapping)mapping;
            if (xmlPropertyMapping.getValueConverterName() != null) {
                String converterName = xmlPropertyMapping.getValueConverterName();
                xmlPropertyMapping.setValueConverter(this.converterLookup.lookupConverter(converterName));
                if (xmlPropertyMapping.getValueConverter() != null) continue;
                throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + xmlPropertyMapping.getName() + "]");
            }
            xmlPropertyMapping.setValueConverter(new SimpleXmlValueConverter());
        }
    }
}

