/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cn.ChineseAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.analyzer.AnalyzerBuilderDelegate;
import org.compass.core.lucene.engine.analyzer.DefaultLuceneAnalyzerFactory;

public class ExtendedAnalyzerBuilderDelegate
implements AnalyzerBuilderDelegate {
    public Analyzer buildAnalyzer(String analyzerName, CompassSettings settings, DefaultLuceneAnalyzerFactory analyzerFactory) throws SearchEngineException {
        String analyzerSetting = settings.getSetting("type", "standard");
        BrazilianAnalyzer analyzer = null;
        if ("brazilian".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new BrazilianAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, BrazilianAnalyzer.BRAZILIAN_STOP_WORDS));
        } else if ("cjk".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new CJKAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, CJKAnalyzer.STOP_WORDS));
        } else if ("chinese".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new ChineseAnalyzer();
        } else if ("czech".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new CzechAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, CzechAnalyzer.CZECH_STOP_WORDS));
        } else if ("german".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new GermanAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, GermanAnalyzer.GERMAN_STOP_WORDS));
        } else if ("greek".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new GreekAnalyzer();
        } else if ("french".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new FrenchAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, FrenchAnalyzer.FRENCH_STOP_WORDS));
        } else if ("dutch".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new DutchAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, DutchAnalyzer.DUTCH_STOP_WORDS));
        } else if ("russian".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new RussianAnalyzer();
        }
        return analyzer;
    }
}

